/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.spi.connector.layout;

import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RepositoryLayout {
    public URI getLocation(Artifact var1, boolean var2);

    public URI getLocation(Metadata var1, boolean var2);

    public List<Checksum> getChecksums(Artifact var1, boolean var2, URI var3);

    public List<Checksum> getChecksums(Metadata var1, boolean var2, URI var3);

    public static final class Checksum {
        private final String algorithm;
        private final URI location;

        public Checksum(String algorithm, URI location) {
            Checksum.verify(algorithm, location);
            this.algorithm = algorithm;
            this.location = location;
        }

        public static Checksum forLocation(URI location, String algorithm) {
            Checksum.verify(algorithm, location);
            if (location.getRawQuery() != null) {
                throw new IllegalArgumentException("resource location must not have query parameters: " + location);
            }
            if (location.getRawFragment() != null) {
                throw new IllegalArgumentException("resource location must not have a fragment: " + location);
            }
            String extension = '.' + algorithm.replace("-", "").toLowerCase(Locale.ENGLISH);
            return new Checksum(algorithm, URI.create(location.toString() + extension));
        }

        private static void verify(String algorithm, URI location) {
            if (algorithm == null || algorithm.length() <= 0) {
                throw new IllegalArgumentException("checksum algorithm has not been specified");
            }
            if (location == null) {
                throw new IllegalArgumentException("checksum location has not been specified");
            }
            if (location.isAbsolute()) {
                throw new IllegalArgumentException("checksum location must be relative");
            }
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public URI getLocation() {
            return this.location;
        }

        public String toString() {
            return this.location + " (" + this.algorithm + ")";
        }
    }
}

