/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.Book;
import com.example.BookService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

@Component
public class RabbitManager {
    public static final Logger LOG = LoggerFactory.getLogger(RabbitManager.class);
    private BookService service;
    private RabbitTemplate rabbitTemplate;

    @Autowired
    public RabbitManager(BookService service, RabbitTemplate rabbitTemplate) {
        this.service = service;
        this.rabbitTemplate = rabbitTemplate;
    }

    @RabbitListener(bindings={@QueueBinding(value=@Queue, exchange=@Exchange(value="input", durable="true", autoDelete="false", type="topic"), key={"event"})})
    public void newBook(Book book, @Header(value="amqp_replyTo") String replyTo) {
        LOG.info("Received new book with bookname = " + book.getName());
        this.service.sendBook(book, replyTo);
    }

    @RabbitListener(bindings={@QueueBinding(value=@Queue, exchange=@Exchange(value="input", durable="true", autoDelete="false", type="topic"), key={"event2"})})
    public void newBook2(Book book, @Header(value="amqp_replyTo") String replyTo) {
        LOG.info("newBook2 Received new book with bookname = " + book.getName());
        this.service.sendBook(book, replyTo);
    }
}

