/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.spec.pact;

import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.Response;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.messaging.Message;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.EvaluationContext;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.path.PathCompiler;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import groovy.lang.GString;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;
import org.springframework.cloud.contract.verifier.spec.pact.ObjectMapperFactory;
import org.springframework.cloud.contract.verifier.spec.pact.ValueGeneratorConverter;
import org.springframework.cloud.contract.verifier.util.ContentUtils;

final class BodyConverter {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.INSTANCE.getMapper();

    private BodyConverter() {
    }

    static DslPart toPactBody(DslProperty<?> dslProperty, Function<DslProperty<?>, Object> dslPropertyValueExtractor) {
        return BodyConverter.traverse(dslProperty, null, dslPropertyValueExtractor);
    }

    private static DslPart traverse(Object value, DslPart parent, Function<DslProperty<?>, Object> dslPropertyValueExtractor) {
        DslPart p;
        String stringValue;
        boolean isRoot = parent == null;
        Object v = value;
        if (v instanceof DslProperty) {
            v = dslPropertyValueExtractor.apply((DslProperty)v);
        }
        if (v instanceof GString) {
            v = ContentUtils.extractValue((GString)((GString)v), dslPropertyValueExtractor);
        }
        if (v instanceof String && StringUtils.startsWith((CharSequence)(stringValue = ((String)v).trim()), (CharSequence)"{") && StringUtils.endsWith((CharSequence)stringValue, (CharSequence)"}")) {
            try {
                v = OBJECT_MAPPER.readValue(stringValue, Object.class);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        DslPart dslPart = p = isRoot ? BodyConverter.createRootDslPart(v) : parent;
        if (v instanceof Map) {
            BodyConverter.processMap((Map)v, (PactDslJsonBody)p, dslPropertyValueExtractor);
        } else if (v instanceof Collection) {
            BodyConverter.processCollection((Collection)v, (PactDslJsonArray)p, dslPropertyValueExtractor);
        }
        return p;
    }

    private static DslPart createRootDslPart(Object value) {
        return value instanceof Collection ? new PactDslJsonArray() : new PactDslJsonBody();
    }

    private static void processCollection(Collection values, PactDslJsonArray jsonArray, Function<DslProperty<?>, Object> dslPropertyValueExtractor) {
        values.forEach(v -> {
            if (v instanceof DslProperty) {
                v = dslPropertyValueExtractor.apply((DslProperty)v);
            }
            if (v instanceof GString) {
                v = ContentUtils.extractValue((GString)((GString)v), (Function)dslPropertyValueExtractor);
            }
            if (v == null) {
                jsonArray.nullValue();
            } else if (v instanceof String) {
                jsonArray.string((String)v);
            } else if (v instanceof Number) {
                jsonArray.number((Number)v);
            } else if (v instanceof Map) {
                PactDslJsonBody current = jsonArray.object();
                BodyConverter.traverse(v, (DslPart)current, dslPropertyValueExtractor);
                current.closeObject();
            } else if (v instanceof Collection) {
                PactDslJsonArray current = jsonArray.array();
                BodyConverter.traverse(v, (DslPart)current, dslPropertyValueExtractor);
                current.closeArray();
            }
        });
    }

    private static void processMap(Map<String, Object> values, PactDslJsonBody jsonObject, Function<DslProperty<?>, Object> dslPropertyValueExtractor) {
        values.forEach((k, v) -> {
            if (v instanceof DslProperty) {
                v = dslPropertyValueExtractor.apply((DslProperty)v);
            }
            if (v instanceof GString) {
                v = ContentUtils.extractValue((GString)((GString)v), (Function)dslPropertyValueExtractor);
            }
            if (v == null) {
                jsonObject.nullValue(k);
            } else if (v instanceof String) {
                jsonObject.stringType(k, (String)v);
            } else if (v instanceof Number) {
                jsonObject.numberValue(k, (Number)v);
            } else if (v instanceof Map) {
                PactDslJsonBody current = jsonObject.object(k);
                BodyConverter.traverse(v, (DslPart)current, dslPropertyValueExtractor);
                current.closeObject();
            } else if (v instanceof Collection) {
                PactDslJsonArray current = jsonObject.array(k);
                BodyConverter.traverse(v, (DslPart)current, dslPropertyValueExtractor);
                current.closeArray();
            }
        });
    }

    static Object toSCCBody(Request request) {
        Object body = BodyConverter.parseBody(request.getBody());
        if (request.getGenerators().isNotEmpty() && request.getGenerators().getCategories().containsKey(Category.BODY)) {
            BodyConverter.applyGenerators(body, (Map)request.getGenerators().getCategories().get(Category.BODY), currentValue -> pattern -> generatedValue -> new DslProperty((Object)new ClientDslProperty(pattern, generatedValue), currentValue));
        }
        return body;
    }

    static Object toSCCBody(Response response) {
        Object body = BodyConverter.parseBody(response.getBody());
        if (response.getGenerators().isNotEmpty() && response.getGenerators().getCategories().containsKey(Category.BODY)) {
            BodyConverter.applyGenerators(body, (Map)response.getGenerators().getCategories().get(Category.BODY), currentValue -> pattern -> generatedValue -> new DslProperty(currentValue, (Object)new ServerDslProperty(pattern, generatedValue)));
        }
        return body;
    }

    static Object toSCCBody(Message message) {
        Object body = BodyConverter.parseBody(message.getContents());
        if (message.getGenerators().isNotEmpty() && message.getGenerators().getCategories().containsKey(Category.BODY)) {
            BodyConverter.applyGenerators(body, (Map)message.getGenerators().getCategories().get(Category.BODY), currentValue -> pattern -> generatedValue -> new DslProperty((Object)new ClientDslProperty(pattern, generatedValue), currentValue));
        }
        return body;
    }

    private static Object parseBody(OptionalBody optionalBody) {
        if (optionalBody.isPresent()) {
            try {
                return OBJECT_MAPPER.readValue(optionalBody.getValue(), Object.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Body could not be read", e);
            }
        }
        return optionalBody.getValue();
    }

    private static void applyGenerators(Object body, Map<String, Generator> generatorsPerPath, Function<Pattern, Function<Object, Function<Object, DslProperty<Object>>>> dslPropertyProvider) {
        Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(OBJECT_MAPPER)).build();
        generatorsPerPath.forEach((path, generator) -> {
            Path compiledPath = PathCompiler.compile((String)path, (Predicate[])new Predicate[0]);
            EvaluationContext evaluationContext = compiledPath.evaluate(body, body, configuration, true);
            evaluationContext.updateOperations().forEach(pathRef -> pathRef.convert((currentValue, config) -> ValueGeneratorConverter.convert(generator, (pattern, generatedValue) -> (DslProperty)((Function)((Function)dslPropertyProvider.apply((Pattern)pattern)).apply(generatedValue)).apply(currentValue)), configuration));
        });
    }
}

