/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.KnownImmutable;
import groovy.transform.ToString;
import java.io.File;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.springframework.cloud.contract.stubrunner.ContractDownloader;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilderProvider;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.converter.ToYamlConverter;
import org.springframework.cloud.contract.verifier.plugin.ContractVerifierExtension;
import org.springframework.cloud.contract.verifier.plugin.GradleContractsDownloaderHelper;
import org.springframework.cloud.contract.verifier.plugin.StubRunnerOptionsFactory;
import org.springframework.util.StringUtils;

class ContractsCopyTask
extends DefaultTask
implements GroovyObject {
    private static final String TASK_NAME = "copyContracts";
    private static final String CONTRACTS = "contracts";
    private static final String BACKUP = "original";
    @Nested
    private Config config;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ContractsCopyTask() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @TaskAction
    public void sync() {
        DownloadedData downloadedData = this.downloadContractsIfNeeded();
        File contractsDirectory = null;
        String antPattern = "";
        if (downloadedData != null) {
            File file;
            contractsDirectory = file = downloadedData.getDownloadedContracts();
            GStringImpl gStringImpl = new GStringImpl(new Object[]{downloadedData.getInclusionProperties().getIncludedRootFolderAntPattern()}, new String[]{"", "*.*"});
            antPattern = ShortTypeHandling.castToString((Object)gStringImpl);
            this.getLogger().info(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Contracts got downloaded to [", (Object)contractsDirectory), (CharSequence)"]"));
        } else if (this.config.getContractsDirectory() != null && this.config.getContractsDirectory().isPresent()) {
            String string;
            File file;
            contractsDirectory = file = ((Directory)this.config.getContractsDirectory().get()).getAsFile();
            antPattern = string = "**/";
        } else {
            Object var8_8 = null;
            contractsDirectory = (File)ScriptBytecodeAdapter.castToType(var8_8, File.class);
        }
        this.getLogger().info("For project [{}] will use contracts provided in the folder [{}]", (Object)((ProjectInternal)this.getProject()).getName(), (Object)contractsDirectory);
        String contractsRepository = this.config.getContractRepository().getRepositoryUrl().isPresent() ? ShortTypeHandling.castToString((Object)this.config.getContractRepository().getRepositoryUrl().get()) : "";
        this.throwExceptionWhenFailOnNoContracts(contractsDirectory, contractsRepository);
        if (contractsDirectory == null) {
            this.getLogger().info("Contracts directory not set and contracts weren't downloaded. There's nothing to copy");
            return;
        }
        String slashSeparatedGroupId = DefaultGroovyMethods.toString((Object)((ProjectInternal)this.getProject()).getGroup()).replace(".", File.separator);
        String slashSeparatedAntPattern = antPattern.replace(slashSeparatedGroupId, DefaultGroovyMethods.toString((Object)((ProjectInternal)this.getProject()).getGroup()));
        File output = ((Directory)this.config.getCopiedContractsFolder().get()).getAsFile();
        this.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{contractsDirectory, output, antPattern, slashSeparatedAntPattern}, new String[]{"Downloading and unpacking files from [", "] to [", "]. The inclusion ant patterns are [", "] and [", "]"})));
        this.sync(contractsDirectory, antPattern, slashSeparatedAntPattern, DefaultTypeTransformation.booleanUnbox((Object)this.config.getExcludeBuildFolders().get()), output);
        Object object = this.config.getConvertToYaml().get();
        if (object == null ? false : (Boolean)object) {
            this.convertBackedUpDslsToYaml(contractsDirectory, antPattern, slashSeparatedAntPattern, output, DefaultTypeTransformation.booleanUnbox((Object)this.config.getExcludeBuildFolders().get()));
        }
    }

    public static Config fromExtension(ContractVerifierExtension extension, String root, Project project) {
        Config config = new Config();
        Property<Boolean> property = extension.getConvertToYaml();
        config.setConvertToYaml((Provider<Boolean>)property);
        Property<Boolean> property2 = extension.getExcludeBuildFolders();
        config.setExcludeBuildFolders((Provider<Boolean>)property2);
        Property<Boolean> property3 = extension.getFailOnNoContracts();
        config.setFailOnNoContracts((Provider<Boolean>)property3);
        DirectoryProperty directoryProperty = extension.getContractsDslDir();
        config.setContractsDirectory((Provider<Directory>)directoryProperty);
        DirectoryProperty directoryProperty2 = extension.getStubsOutputDir();
        config.setStubsOutputDir(directoryProperty2);
        DirectoryProperty directoryProperty3 = ContractsCopyTask.createTaskOutput(root, extension.getStubsOutputDir(), ContractsCopyTask.getCONTRACTS(), project);
        config.setCopiedContractsFolder(directoryProperty3);
        DirectoryProperty directoryProperty4 = ContractsCopyTask.createTaskOutput(root, extension.getStubsOutputDir(), ContractsCopyTask.getBACKUP(), project);
        config.setBackupContractsFolder(directoryProperty4);
        ContractVerifierExtension.Dependency dependency = extension.getContractDependency();
        config.setContractDependency(dependency);
        ContractVerifierExtension.ContractRepository contractRepository = extension.getContractRepository();
        config.setContractRepository(contractRepository);
        Property<StubRunnerProperties.StubsMode> property4 = extension.getContractsMode();
        config.setContractsMode(property4);
        Property<Boolean> property5 = extension.getDeleteStubsAfterTest();
        config.setDeleteStubsAfterTest(property5);
        MapProperty<String, String> mapProperty = extension.getContractsProperties();
        config.setContractsProperties(mapProperty);
        Property<String> property6 = extension.getContractsPath();
        config.setContractsPath(property6);
        return config;
    }

    private void convertBackedUpDslsToYaml(File file, String antPattern, String slashSeparatedAntPattern, File outputContractsFolder, boolean excludeBuildFolders) {
        this.sync(file, antPattern, slashSeparatedAntPattern, excludeBuildFolders, ((Directory)this.config.getBackupContractsFolder().get()).getAsFile());
        ToYamlConverter.replaceContractWithYaml((File)outputContractsFolder);
        this.getLogger().info(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Replaced DSL files with their YAML representation at [", (Object)outputContractsFolder), (CharSequence)"]"));
    }

    /*
     * WARNING - void declaration
     */
    protected WorkResult sync(File file, String antPattern, String slashSeparatedAntPattern, boolean excludeBuildFolders, File outputContractsFolder) {
        void var3_3;
        void var2_2;
        Reference file2 = new Reference((Object)file);
        Reference antPattern2 = new Reference((Object)var2_2);
        Reference slashSeparatedAntPattern2 = new Reference((Object)var3_3);
        Reference excludeBuildFolders2 = new Reference((Object)excludeBuildFolders);
        Reference outputContractsFolder2 = new Reference((Object)outputContractsFolder);
        return ((ProjectInternal)this.getProject()).sync((Action)new Action<CopySpec>(this, file2, antPattern2, slashSeparatedAntPattern2, excludeBuildFolders2, outputContractsFolder2){
            public /* synthetic */ Reference outputContractsFolder;
            public /* synthetic */ Reference excludeBuildFolders;
            public /* synthetic */ Reference slashSeparatedAntPattern;
            public /* synthetic */ Reference antPattern;
            public /* synthetic */ Reference file;
            public /* synthetic */ ContractsCopyTask this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                ContractsCopyTask contractsCopyTask;
                this.this$0 = contractsCopyTask = p0;
                this.outputContractsFolder = reference5 = p5;
                this.excludeBuildFolders = reference4 = p4;
                this.slashSeparatedAntPattern = reference3 = p3;
                this.antPattern = reference2 = p2;
                this.file = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void execute(CopySpec spec) {
                public final class _execute_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference file;
                    private /* synthetic */ Reference antPattern;
                    private /* synthetic */ Reference slashSeparatedAntPattern;
                    private /* synthetic */ Reference excludeBuildFolders;
                    private /* synthetic */ Reference outputContractsFolder;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _execute_closure1(Object _outerInstance, Object _thisObject, Reference file, Reference antPattern, Reference slashSeparatedAntPattern, Reference excludeBuildFolders, Reference outputContractsFolder) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        this.file = reference5 = file;
                        this.antPattern = reference4 = antPattern;
                        this.slashSeparatedAntPattern = reference3 = slashSeparatedAntPattern;
                        this.excludeBuildFolders = reference2 = excludeBuildFolders;
                        this.outputContractsFolder = reference = outputContractsFolder;
                    }

                    public Object doCall(Object it) {
                        ((CopySpec)this.getDelegate()).from(new Object[]{this.file.get()});
                        ((CopySpec)this.getDelegate()).include(new String[]{ShortTypeHandling.castToString((Object)this.antPattern.get())});
                        ((CopySpec)this.getDelegate()).include(new String[]{ShortTypeHandling.castToString((Object)this.slashSeparatedAntPattern.get())});
                        if (DefaultTypeTransformation.booleanUnbox((Object)this.excludeBuildFolders.get())) {
                            ((CopySpec)this.getDelegate()).exclude(new String[]{"**/target/**", "**/build/**", "**/.mvn/**", "**/.gradle/**"});
                        }
                        return ((CopySpec)this.getDelegate()).into(this.outputContractsFolder.get());
                    }

                    @Generated
                    public File getFile() {
                        return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                    }

                    @Generated
                    public String getAntPattern() {
                        return ShortTypeHandling.castToString((Object)this.antPattern.get());
                    }

                    @Generated
                    public String getSlashSeparatedAntPattern() {
                        return ShortTypeHandling.castToString((Object)this.slashSeparatedAntPattern.get());
                    }

                    @Generated
                    public boolean getExcludeBuildFolders() {
                        return DefaultTypeTransformation.booleanUnbox((Object)this.excludeBuildFolders.get());
                    }

                    @Generated
                    public File getOutputContractsFolder() {
                        return (File)ScriptBytecodeAdapter.castToType((Object)this.outputContractsFolder.get(), File.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _execute_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.with((Object)spec, (Closure)new _execute_closure1(this, this, this.file, this.antPattern, this.slashSeparatedAntPattern, this.excludeBuildFolders, this.outputContractsFolder));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$3(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$3(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$3(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        });
    }

    private DownloadedData downloadContractsIfNeeded() {
        if (this.config.shouldDownloadContracts()) {
            this.getLogger().info("Project has group id [{}], artifact id [{}]", ((ProjectInternal)this.getProject()).getGroup(), (Object)((ProjectInternal)this.getProject()).getName());
            this.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((ProjectInternal)this.getProject()).getName()}, new String[]{"For project [", "] Download dependency is provided - will download contract jars"})));
            this.getLogger().info("Contract dependency [{}]", (Object)this.config.getContractDependency());
            StubConfiguration configuration = this.config.getStubConfiguration();
            this.getLogger().info("Got the following contract dependency to download [{}]", (Object)configuration);
            this.getLogger().info("The contract dependency is a changing one [{}]", (Object)configuration.isVersionChanging());
            StubDownloader downloader = new StubDownloaderBuilderProvider().get(StubRunnerOptionsFactory.createStubRunnerOptions(this.config.getContractRepository(), (StubRunnerProperties.StubsMode)ShortTypeHandling.castToEnum((Object)this.config.getContractsMode().getOrNull(), StubRunnerProperties.StubsMode.class), DefaultTypeTransformation.booleanUnbox((Object)this.config.getDeleteStubsAfterTest().get()), (Map)ScriptBytecodeAdapter.castToType((Object)this.config.getContractsProperties().get(), Map.class), DefaultTypeTransformation.booleanUnbox((Object)this.config.getFailOnNoContracts().get())), new StubDownloaderBuilder[0]);
            ContractDownloader contractDownloader = new ContractDownloader(downloader, configuration, ShortTypeHandling.castToString((Object)this.config.getContractsPath().getOrNull()), (String)ScriptBytecodeAdapter.asType((Object)((ProjectInternal)this.getProject()).getGroup(), String.class), ((ProjectInternal)this.getProject()).getName(), (String)ScriptBytecodeAdapter.asType((Object)((ProjectInternal)this.getProject()).getVersion(), String.class));
            File downloadedContracts = contractDownloader.unpackAndDownloadContracts();
            ContractDownloader.InclusionProperties inclusionProperties = contractDownloader.createNewInclusionProperties(downloadedContracts);
            return new DownloadedData(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"downloadedContracts", ContractsCopyTask.contractsSubDirIfPresent(downloadedContracts, this.getLogger()), "inclusionProperties", inclusionProperties}));
        }
        return (DownloadedData)ScriptBytecodeAdapter.castToType(null, DownloadedData.class);
    }

    /*
     * WARNING - void declaration
     */
    private static DirectoryProperty createTaskOutput(String root, DirectoryProperty stubsOutputDir, String suffix, Project project) {
        void var3_3;
        void var2_2;
        Reference root2 = new Reference((Object)root);
        Reference suffix2 = new Reference((Object)var2_2);
        Reference project2 = new Reference((Object)var3_3);
        public final class _createTaskOutput_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference root;
            private /* synthetic */ Reference suffix;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createTaskOutput_closure1(Object _outerInstance, Object _thisObject, Reference project, Reference root, Reference suffix) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.project = reference3 = project;
                this.root = reference2 = root;
                this.suffix = reference = suffix;
            }

            public Object doCall(Object it) {
                Directory dir = (Directory)ScriptBytecodeAdapter.castToType((Object)it, Directory.class);
                File output = ((Project)this.project.get()).file((Object)new GStringImpl(new Object[]{dir.getAsFile(), this.root.get(), this.suffix.get()}, new String[]{"", "/", "/", ""}));
                DirectoryProperty property = ((Project)this.project.get()).getObjects().directoryProperty();
                property.set(output);
                return property;
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            @Generated
            public String getRoot() {
                return ShortTypeHandling.castToString((Object)this.root.get());
            }

            @Generated
            public String getSuffix() {
                return ShortTypeHandling.castToString((Object)this.suffix.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createTaskOutput_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Provider provider = stubsOutputDir.flatMap((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _createTaskOutput_closure1(ContractsCopyTask.class, ContractsCopyTask.class, project2, root2, suffix2)), Transformer.class));
        DirectoryProperty property = ((Project)project2.get()).getObjects().directoryProperty();
        property.set(provider);
        return property;
    }

    private void throwExceptionWhenFailOnNoContracts(File file, String contractsRepository) {
        if (StringUtils.hasText((String)contractsRepository)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Contracts repository is set, will not throw an exception that the contracts are not found");
            }
            return;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.config.getFailOnNoContracts().get()) && (file == null || !file.exists() || file.listFiles().length == 0)) {
            String path = file != null ? file.getAbsolutePath() : this.config.getContractsDirectoryPath();
            throw (Throwable)new GradleException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Contracts could not be found: [", (CharSequence)path), (CharSequence)"]\nPlease make sure that the contracts were defined, or set the [failOnNoContracts] flag to [false]"));
        }
    }

    private static File contractsSubDirIfPresent(File contractsDirectory, Logger logger) {
        File contracts = new File(contractsDirectory, CONTRACTS);
        if (contracts.exists()) {
            File file;
            if (logger.isDebugEnabled()) {
                logger.debug(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Contracts folder found [", (Object)contracts), (CharSequence)"]"));
            }
            contractsDirectory = file = contracts;
        }
        return contractsDirectory;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ContractsCopyTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ContractsCopyTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ContractsCopyTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ContractsCopyTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public static String getTASK_NAME() {
        return TASK_NAME;
    }

    @Generated
    public static String getCONTRACTS() {
        return CONTRACTS;
    }

    @Generated
    public static String getBACKUP() {
        return BACKUP;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(Config config) {
        this.config = config;
    }

    public static class Config
    implements GroovyObject {
        @Input
        private Provider<Boolean> convertToYaml;
        @Input
        private Provider<Boolean> excludeBuildFolders;
        @Input
        private Provider<Boolean> failOnNoContracts;
        private String contractsDirectoryPath;
        private Provider<Directory> contractsDirectory;
        @Nested
        @Optional
        private ContractVerifierExtension.Dependency contractDependency;
        @Nested
        @Optional
        private ContractVerifierExtension.ContractRepository contractRepository;
        @Input
        @Optional
        private Property<StubRunnerProperties.StubsMode> contractsMode;
        @Input
        private Property<Boolean> deleteStubsAfterTest;
        @Input
        private MapProperty<String, String> contractsProperties;
        @Input
        @Optional
        private Property<String> contractsPath;
        @OutputDirectory
        private DirectoryProperty copiedContractsFolder;
        @OutputDirectory
        private DirectoryProperty stubsOutputDir;
        @Optional
        @OutputDirectory
        private DirectoryProperty backupContractsFolder;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public Config() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Input
        @Optional
        public Instant getForceDownloadOfTheLatestContracts() {
            if (this.shouldDownloadContracts() && this.getStubConfiguration().isVersionChanging()) {
                return Instant.now();
            }
            return (Instant)ScriptBytecodeAdapter.castToType(null, Instant.class);
        }

        @Optional
        @InputDirectory
        public Provider<Directory> getContractsDirectory() {
            String string;
            this.contractsDirectoryPath = string = ((Directory)this.contractsDirectory.get()).getAsFile().getAbsolutePath();
            if (this.shouldDownloadContracts() || this.contractFolderMissing()) {
                return (Provider)ScriptBytecodeAdapter.castToType(null, Provider.class);
            }
            return this.contractsDirectory;
        }

        private boolean contractFolderMissing() {
            return this.contractsDirectory.isPresent() && !((Directory)this.contractsDirectory.get()).getAsFile().exists();
        }

        @org.gradle.api.tasks.Internal
        public boolean shouldDownloadContracts() {
            return StringUtils.hasText((String)ShortTypeHandling.castToString((Object)this.contractDependency.getArtifactId().getOrNull())) || StringUtils.hasText((String)ShortTypeHandling.castToString((Object)this.contractDependency.getStringNotation().getOrNull())) || StringUtils.hasText((String)ShortTypeHandling.castToString((Object)this.contractRepository.getRepositoryUrl().getOrNull()));
        }

        @org.gradle.api.tasks.Internal
        public StubConfiguration getStubConfiguration() {
            return GradleContractsDownloaderHelper.stubConfiguration(this.contractDependency);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Config.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Provider<Boolean> getConvertToYaml() {
            return this.convertToYaml;
        }

        @Generated
        public void setConvertToYaml(Provider<Boolean> provider) {
            this.convertToYaml = provider;
        }

        @Generated
        public Provider<Boolean> getExcludeBuildFolders() {
            return this.excludeBuildFolders;
        }

        @Generated
        public void setExcludeBuildFolders(Provider<Boolean> provider) {
            this.excludeBuildFolders = provider;
        }

        @Generated
        public Provider<Boolean> getFailOnNoContracts() {
            return this.failOnNoContracts;
        }

        @Generated
        public void setFailOnNoContracts(Provider<Boolean> provider) {
            this.failOnNoContracts = provider;
        }

        @Generated
        public String getContractsDirectoryPath() {
            return this.contractsDirectoryPath;
        }

        @Generated
        public void setContractsDirectoryPath(String string) {
            this.contractsDirectoryPath = string;
        }

        @Generated
        public void setContractsDirectory(Provider<Directory> provider) {
            this.contractsDirectory = provider;
        }

        @Generated
        public ContractVerifierExtension.Dependency getContractDependency() {
            return this.contractDependency;
        }

        @Generated
        public void setContractDependency(ContractVerifierExtension.Dependency dependency) {
            this.contractDependency = dependency;
        }

        @Generated
        public ContractVerifierExtension.ContractRepository getContractRepository() {
            return this.contractRepository;
        }

        @Generated
        public void setContractRepository(ContractVerifierExtension.ContractRepository contractRepository) {
            this.contractRepository = contractRepository;
        }

        @Generated
        public Property<StubRunnerProperties.StubsMode> getContractsMode() {
            return this.contractsMode;
        }

        @Generated
        public void setContractsMode(Property<StubRunnerProperties.StubsMode> property) {
            this.contractsMode = property;
        }

        @Generated
        public Property<Boolean> getDeleteStubsAfterTest() {
            return this.deleteStubsAfterTest;
        }

        @Generated
        public void setDeleteStubsAfterTest(Property<Boolean> property) {
            this.deleteStubsAfterTest = property;
        }

        @Generated
        public MapProperty<String, String> getContractsProperties() {
            return this.contractsProperties;
        }

        @Generated
        public void setContractsProperties(MapProperty<String, String> mapProperty) {
            this.contractsProperties = mapProperty;
        }

        @Generated
        public Property<String> getContractsPath() {
            return this.contractsPath;
        }

        @Generated
        public void setContractsPath(Property<String> property) {
            this.contractsPath = property;
        }

        @Generated
        public DirectoryProperty getCopiedContractsFolder() {
            return this.copiedContractsFolder;
        }

        @Generated
        public void setCopiedContractsFolder(DirectoryProperty directoryProperty) {
            this.copiedContractsFolder = directoryProperty;
        }

        @Generated
        public DirectoryProperty getStubsOutputDir() {
            return this.stubsOutputDir;
        }

        @Generated
        public void setStubsOutputDir(DirectoryProperty directoryProperty) {
            this.stubsOutputDir = directoryProperty;
        }

        @Generated
        public DirectoryProperty getBackupContractsFolder() {
            return this.backupContractsFolder;
        }

        @Generated
        public void setBackupContractsFolder(DirectoryProperty directoryProperty) {
            this.backupContractsFolder = directoryProperty;
        }
    }

    @ToString(cache=true, includeSuperProperties=true)
    @EqualsAndHashCode(cache=true)
    @KnownImmutable
    static final class DownloadedData
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private /* synthetic */ String $to$string;
        private /* synthetic */ int $hash$code;
        private final File downloadedContracts;
        private final ContractDownloader.InclusionProperties inclusionProperties;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public DownloadedData(File downloadedContracts, ContractDownloader.InclusionProperties inclusionProperties) {
            ContractDownloader.InclusionProperties inclusionProperties2;
            File file;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.downloadedContracts = file = downloadedContracts;
            this.inclusionProperties = inclusionProperties2 = inclusionProperties;
        }

        @Generated
        public DownloadedData(Map args) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (args == null) {
                Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                args = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)map, LinkedHashMap.class);
            }
            ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
            if (args.containsKey("downloadedContracts")) {
                File file;
                this.downloadedContracts = file = (File)ScriptBytecodeAdapter.castToType(args.get("downloadedContracts"), File.class);
            } else {
                Object var5_5 = null;
                this.downloadedContracts = (File)ScriptBytecodeAdapter.castToType(var5_5, File.class);
            }
            if (args.containsKey("inclusionProperties")) {
                ContractDownloader.InclusionProperties inclusionProperties;
                this.inclusionProperties = inclusionProperties = (ContractDownloader.InclusionProperties)ScriptBytecodeAdapter.castToType(args.get("inclusionProperties"), ContractDownloader.InclusionProperties.class);
            } else {
                Object var7_7 = null;
                this.inclusionProperties = (ContractDownloader.InclusionProperties)ScriptBytecodeAdapter.castToType(var7_7, ContractDownloader.InclusionProperties.class);
            }
        }

        @Generated
        public DownloadedData() {
            this(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DownloadedData.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("org.springframework.cloud.contract.verifier.plugin.ContractsCopyTask$DownloadedData(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getDownloadedContracts()));
            Boolean bl3 = $toStringFirst;
            if (bl3 == null ? false : bl3) {
                Boolean bl4;
                $toStringFirst = bl4 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getInclusionProperties()));
            _result.append(")");
            if (this.$to$string == null) {
                String string;
                this.$to$string = string = _result.toString();
            }
            return this.$to$string;
        }

        @Generated
        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!(this.getDownloadedContracts() == this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)this.getDownloadedContracts());
                }
                if (!(this.getInclusionProperties() == this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)this.getInclusionProperties());
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof DownloadedData;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof DownloadedData)) {
                return false;
            }
            DownloadedData otherTyped = (DownloadedData)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)this.getDownloadedContracts(), (Object)otherTyped.getDownloadedContracts())) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getInclusionProperties(), (Object)otherTyped.getInclusionProperties()));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DownloadedData.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DownloadedData.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DownloadedData.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DownloadedData.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public final File getDownloadedContracts() {
            return this.downloadedContracts;
        }

        @Generated
        public final ContractDownloader.InclusionProperties getInclusionProperties() {
            return this.inclusionProperties;
        }
    }
}

