/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.encrypt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.MiscPEMGenerator;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.springframework.cloud.context.encrypt.KeyFormatException;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;

public class EncryptorFactory {
    private static final Pattern NEWLINE_ESCAPE_PATTERN = Pattern.compile("\\r|\\n");
    private String salt = "deadbeef";

    public EncryptorFactory() {
    }

    public EncryptorFactory(String salt) {
        this.salt = salt;
    }

    public TextEncryptor create(String data) {
        TextEncryptor encryptor;
        if (data.contains("RSA PRIVATE KEY")) {
            try {
                String normalizedPemData = this.normalizePem(data);
                encryptor = new RsaSecretEncryptor(NEWLINE_ESCAPE_PATTERN.matcher(normalizedPemData).replaceAll(""));
            }
            catch (IllegalArgumentException e) {
                throw new KeyFormatException(e);
            }
        } else {
            if (data.startsWith("ssh-rsa") || data.contains("RSA PUBLIC KEY")) {
                throw new KeyFormatException();
            }
            encryptor = Encryptors.text((CharSequence)data, (CharSequence)this.salt);
        }
        return encryptor;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String normalizePem(String data) {
        PEMKeyPair pemKeyPair = null;
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(data));){
            String string;
            pemKeyPair = (PEMKeyPair)pemParser.readObject();
            PrivateKeyInfo privateKeyInfo = pemKeyPair.getPrivateKeyInfo();
            StringWriter textWriter = new StringWriter();
            try (PemWriter pemWriter = new PemWriter((Writer)textWriter);){
                MiscPEMGenerator pemObjectGenerator = new MiscPEMGenerator((Object)privateKeyInfo);
                pemWriter.writeObject((PemObjectGenerator)pemObjectGenerator);
                pemWriter.flush();
                string = textWriter.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

