/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.env.EnvironmentEndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.env.EnvironmentEndpointProperties;
import org.springframework.boot.actuate.env.EnvironmentEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.autoconfigure.LifecycleMvcEndpointAutoConfiguration;
import org.springframework.cloud.context.environment.EnvironmentManager;
import org.springframework.cloud.context.environment.WritableEnvironmentEndpoint;
import org.springframework.cloud.context.environment.WritableEnvironmentEndpointWebExtension;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EnvironmentEndpoint.class, EnvironmentEndpointProperties.class})
@ConditionalOnBean(value={EnvironmentManager.class})
@AutoConfigureBefore(value={EnvironmentEndpointAutoConfiguration.class})
@AutoConfigureAfter(value={LifecycleMvcEndpointAutoConfiguration.class})
@EnableConfigurationProperties(value={EnvironmentEndpointProperties.class})
@ConditionalOnProperty(value={"management.endpoint.env.post.enabled"})
public class WritableEnvironmentEndpointAutoConfiguration {
    private final EnvironmentEndpointProperties properties;

    public WritableEnvironmentEndpointAutoConfiguration(EnvironmentEndpointProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public WritableEnvironmentEndpoint writableEnvironmentEndpoint(Environment environment) {
        WritableEnvironmentEndpoint endpoint = new WritableEnvironmentEndpoint(environment);
        String[] keysToSanitize = this.properties.getKeysToSanitize();
        if (keysToSanitize != null) {
            endpoint.setKeysToSanitize(keysToSanitize);
        }
        return endpoint;
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public WritableEnvironmentEndpointWebExtension writableEnvironmentEndpointWebExtension(WritableEnvironmentEndpoint endpoint, EnvironmentManager environment) {
        return new WritableEnvironmentEndpointWebExtension(endpoint, environment);
    }
}

