/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.config;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class BootstrapPropertySource<T>
extends EnumerablePropertySource<T> {
    private PropertySource<T> delegate;

    public BootstrapPropertySource(PropertySource<T> delegate) {
        super("bootstrapProperties-" + delegate.getName(), delegate.getSource());
        this.delegate = delegate;
    }

    public Object getProperty(String name) {
        return this.delegate.getProperty(name);
    }

    public String[] getPropertyNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (!(this.delegate instanceof EnumerablePropertySource)) {
            throw new IllegalStateException("Failed to enumerate property names due to non-enumerable property source: " + this.delegate);
        }
        names.addAll(Arrays.asList(((EnumerablePropertySource)this.delegate).getPropertyNames()));
        return StringUtils.toStringArray(names);
    }

    public PropertySource<T> getDelegate() {
        return this.delegate;
    }
}

