/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery.configclient;

import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnClass(value={ConsulDiscoveryProperties.class, ConsulClient.class, ConfigServerProperties.class})
public class ConsulConfigServerAutoConfiguration {
    public static final String CONFIG_PATH_KEY = "configPath";
    @Autowired(required=false)
    private ConsulDiscoveryProperties properties;
    @Autowired(required=false)
    private ConfigServerProperties server;

    @PostConstruct
    public void init() {
        if (this.properties == null || this.server == null) {
            return;
        }
        String prefix = this.server.getPrefix();
        if (StringUtils.hasText((String)prefix)) {
            this.properties.getMetadata().put(CONFIG_PATH_KEY, prefix);
        }
    }
}

