/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.ConsulServerUtils;

public class ConsulDiscoveryClient
implements DiscoveryClient {
    private static final Log log = LogFactory.getLog(ConsulDiscoveryClient.class);
    private final ConsulClient client;
    private final ConsulDiscoveryProperties properties;

    public ConsulDiscoveryClient(ConsulClient client, ConsulDiscoveryProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public String description() {
        return "Spring Cloud Consul Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        return this.getInstances(serviceId, new QueryParams(this.properties.getConsistencyMode()));
    }

    public List<ServiceInstance> getInstances(String serviceId, QueryParams queryParams) {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        this.addInstancesToList(instances, serviceId, queryParams);
        return instances;
    }

    private void addInstancesToList(List<ServiceInstance> instances, String serviceId, QueryParams queryParams) {
        HealthServicesRequest request = HealthServicesRequest.newBuilder().setTag(this.properties.getDefaultQueryTag()).setPassing(this.properties.isQueryPassing()).setQueryParams(queryParams).setToken(this.properties.getAclToken()).build();
        Response services = this.client.getHealthServices(serviceId, request);
        for (HealthService service : (List)services.getValue()) {
            String host = ConsulServerUtils.findHost(service);
            LinkedHashMap metadata = service.getService().getMeta();
            if (metadata == null) {
                metadata = new LinkedHashMap();
            }
            boolean secure = false;
            if (metadata.containsKey("secure")) {
                secure = Boolean.parseBoolean((String)metadata.get("secure"));
            }
            instances.add((ServiceInstance)new DefaultServiceInstance(service.getService().getId(), serviceId, host, service.getService().getPort().intValue(), secure, metadata));
        }
    }

    public List<ServiceInstance> getAllInstances() {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        Response services = this.client.getCatalogServices(CatalogServicesRequest.newBuilder().setQueryParams(QueryParams.DEFAULT).build());
        for (String serviceId : ((Map)services.getValue()).keySet()) {
            this.addInstancesToList(instances, serviceId, QueryParams.DEFAULT);
        }
        return instances;
    }

    public List<String> getServices() {
        CatalogServicesRequest request = CatalogServicesRequest.newBuilder().setQueryParams(QueryParams.DEFAULT).setToken(this.properties.getAclToken()).build();
        return new ArrayList<String>(((Map)this.client.getCatalogServices(request).getValue()).keySet());
    }

    public int getOrder() {
        return this.properties.getOrder();
    }

    @Deprecated
    public static interface LocalResolver {
        public String getInstanceId();

        public Integer getPort();
    }
}

