/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.serviceregistry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistry;
import org.springframework.retry.annotation.Retryable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConsulAutoServiceRegistration
extends AbstractAutoServiceRegistration<ConsulRegistration> {
    private static Log log = LogFactory.getLog(ConsulAutoServiceRegistration.class);
    private ConsulDiscoveryProperties properties;
    private ConsulAutoRegistration registration;

    public ConsulAutoServiceRegistration(ConsulServiceRegistry serviceRegistry, AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ConsulAutoRegistration registration) {
        super((ServiceRegistry)serviceRegistry, autoServiceRegistrationProperties);
        this.properties = properties;
        this.registration = registration;
    }

    @Deprecated
    public void setPort(int port) {
        this.getPort().set(port);
    }

    protected ConsulAutoRegistration getRegistration() {
        if (this.registration.getService().getPort() == null && this.getPort().get() > 0) {
            this.registration.initializePort(this.getPort().get());
        }
        Assert.notNull((Object)this.registration.getService().getPort(), (String)"service.port has not been set");
        return this.registration;
    }

    protected ConsulAutoRegistration getManagementRegistration() {
        return this.registration.managementRegistration();
    }

    @Retryable(interceptor="consulRetryInterceptor")
    public void start() {
        super.start();
    }

    protected void register() {
        if (!this.properties.isRegister()) {
            log.debug((Object)"Registration disabled.");
            return;
        }
        super.register();
    }

    protected void registerManagement() {
        if (!this.properties.isRegister()) {
            return;
        }
        super.registerManagement();
    }

    protected Object getConfiguration() {
        return this.properties;
    }

    protected void deregister() {
        if (!this.properties.isRegister() || !this.properties.isDeregister()) {
            return;
        }
        super.deregister();
    }

    protected void deregisterManagement() {
        if (!this.properties.isRegister() || !this.properties.isDeregister()) {
            return;
        }
        super.deregisterManagement();
    }

    protected boolean isEnabled() {
        return this.properties.getLifecycle().isEnabled();
    }

    protected String getAppName() {
        String appName = this.properties.getServiceName();
        return StringUtils.isEmpty((Object)appName) ? super.getAppName() : appName;
    }
}

