/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Period;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.style.ToStringCreator;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="spring.cloud.consul.discovery.heartbeat")
@Validated
public class HeartbeatProperties {
    private static final Log log = LogFactory.getLog(HeartbeatProperties.class);
    boolean enabled = false;
    @Min(value=1L)
    private @Min(value=1L) int ttlValue = 30;
    @NotNull
    private String ttlUnit = "s";
    @DecimalMin(value="0.1")
    @DecimalMax(value="0.9")
    private @DecimalMin(value="0.1") @DecimalMax(value="0.9") double intervalRatio = 0.6666666666666666;

    protected Period computeHearbeatInterval() {
        double interval = (double)this.ttlValue * this.intervalRatio;
        double max = Math.max(interval, 1.0);
        int ttlMinus1 = this.ttlValue - 1;
        double min = Math.min((double)ttlMinus1, max);
        Period heartbeatInterval = new Period(Math.round(1000.0 * min));
        log.debug((Object)("Computed heartbeatInterval: " + heartbeatInterval));
        return heartbeatInterval;
    }

    public String getTtl() {
        return this.ttlValue + this.ttlUnit;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTtlValue() {
        return this.ttlValue;
    }

    @NotNull
    public String getTtlUnit() {
        return this.ttlUnit;
    }

    @DecimalMin(value="0.1")
    @DecimalMax(value="0.9")
    public @DecimalMin(value="0.1") @DecimalMax(value="0.9") double getIntervalRatio() {
        return this.intervalRatio;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTtlValue(@Min(value=1L) @Min(value=1L) int ttlValue) {
        this.ttlValue = ttlValue;
    }

    public void setTtlUnit(@NotNull String ttlUnit) {
        this.ttlUnit = ttlUnit;
    }

    public void setIntervalRatio(@DecimalMin(value="0.1") @DecimalMax(value="0.9") @DecimalMin(value="0.1") @DecimalMax(value="0.9") double intervalRatio) {
        this.intervalRatio = intervalRatio;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("enabled", this.enabled).append("ttlValue", this.ttlValue).append("ttlUnit", (Object)this.ttlUnit).append("intervalRatio", this.intervalRatio).toString();
    }
}

