/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.Member;
import com.ecwid.consul.v1.agent.model.Self;
import com.ecwid.consul.v1.agent.model.Service;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.ConsulLifecycle;
import org.springframework.cloud.consul.discovery.ConsulServerUtils;
import org.springframework.util.StringUtils;

public class ConsulDiscoveryClient
implements DiscoveryClient {
    private static final Log log = LogFactory.getLog(ConsulDiscoveryClient.class);
    private final ConsulClient client;
    private final ConsulDiscoveryProperties properties;
    private final LocalResolver localResolver;
    private ServerProperties serverProperties;

    @Deprecated
    public ConsulDiscoveryClient(ConsulClient client, final ConsulLifecycle lifecycle, ConsulDiscoveryProperties properties) {
        this(client, properties, new LocalResolver(){

            @Override
            public String getInstanceId() {
                return lifecycle.getInstanceId();
            }

            @Override
            public Integer getPort() {
                return lifecycle.getConfiguredPort();
            }
        });
    }

    public ConsulDiscoveryClient(ConsulClient client, ConsulDiscoveryProperties properties, LocalResolver localResolver) {
        this.client = client;
        this.properties = properties;
        this.localResolver = localResolver;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public String description() {
        return "Spring Cloud Consul Discovery Client";
    }

    public ServiceInstance getLocalServiceInstance() {
        Map<String, String> metadata;
        Integer port;
        String instanceId;
        Response agentServices = this.client.getAgentServices();
        Service service = (Service)((Map)agentServices.getValue()).get(this.localResolver.getInstanceId());
        String host = "localhost";
        if (service != null) {
            instanceId = service.getId();
            port = service.getPort();
            host = service.getAddress();
            metadata = ConsulServerUtils.getMetadata(service.getTags());
        } else {
            String agentHost;
            log.warn((Object)("getLocalServiceInstance(): Unable to locate service in consul agent: " + this.localResolver.getInstanceId()));
            instanceId = this.localResolver.getInstanceId();
            port = this.localResolver.getPort();
            if (port != null && port == 0 && this.serverProperties != null && this.serverProperties.getPort() != null) {
                port = this.serverProperties.getPort();
            }
            metadata = ConsulServerUtils.getMetadata(this.properties.getTags());
            if (StringUtils.hasText((String)this.properties.getHostname())) {
                host = this.properties.getHostname();
            } else if (this.properties.isPreferAgentAddress() && (agentHost = this.getAgentHost()) != null) {
                host = agentHost;
            }
        }
        if (port == null) {
            log.warn((Object)"getLocalServiceInstance(): Unable to determine port.");
            port = 0;
        }
        return new DefaultServiceInstance(instanceId, host, port.intValue(), false, metadata);
    }

    private String getAgentHost() {
        Response agentSelf = this.client.getAgentSelf();
        Member member = ((Self)agentSelf.getValue()).getMember();
        if (member != null) {
            if (this.properties.isPreferIpAddress()) {
                return member.getAddress();
            }
            if (StringUtils.hasText((String)member.getName())) {
                return member.getName();
            }
        }
        return null;
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        return this.getInstances(serviceId, QueryParams.DEFAULT);
    }

    public List<ServiceInstance> getInstances(String serviceId, QueryParams queryParams) {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        this.addInstancesToList(instances, serviceId, queryParams);
        return instances;
    }

    private void addInstancesToList(List<ServiceInstance> instances, String serviceId, QueryParams queryParams) {
        String aclToken = this.properties.getAclToken();
        Response services = StringUtils.hasText((String)aclToken) ? this.client.getHealthServices(serviceId, this.properties.getDefaultQueryTag(), this.properties.isQueryPassing(), queryParams, aclToken) : this.client.getHealthServices(serviceId, this.properties.getDefaultQueryTag(), this.properties.isQueryPassing(), queryParams);
        for (HealthService service : (List)services.getValue()) {
            String host = ConsulServerUtils.findHost(service);
            instances.add((ServiceInstance)new DefaultServiceInstance(serviceId, host, service.getService().getPort().intValue(), false, ConsulServerUtils.getMetadata(service)));
        }
    }

    public List<ServiceInstance> getAllInstances() {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        Response services = this.client.getCatalogServices(QueryParams.DEFAULT);
        for (String serviceId : ((Map)services.getValue()).keySet()) {
            this.addInstancesToList(instances, serviceId, QueryParams.DEFAULT);
        }
        return instances;
    }

    public List<String> getServices() {
        String aclToken = this.properties.getAclToken();
        if (StringUtils.hasText((String)aclToken)) {
            return new ArrayList<String>(((Map)this.client.getCatalogServices(QueryParams.DEFAULT, aclToken).getValue()).keySet());
        }
        return new ArrayList<String>(((Map)this.client.getCatalogServices(QueryParams.DEFAULT).getValue()).keySet());
    }

    public static interface LocalResolver {
        public String getInstanceId();

        public Integer getPort();
    }
}

