/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.util.PropertyUtils;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ConsulConfigDataMissingEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int ORDER = -2147482638;

    public int getOrder() {
        return -2147482638;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (PropertyUtils.bootstrapEnabled((Environment)environment) || PropertyUtils.useLegacyProcessing((Environment)environment)) {
            return;
        }
        boolean coreEnabled = (Boolean)environment.getProperty("spring.cloud.consul.enabled", Boolean.class, (Object)true);
        boolean configEnabled = (Boolean)environment.getProperty("spring.cloud.consul.config.enabled", Boolean.class, (Object)true);
        boolean importCheckEnabled = (Boolean)environment.getProperty("spring.cloud.consul.config.import-check.enabled", Boolean.class, (Object)true);
        if (!(coreEnabled && configEnabled && importCheckEnabled)) {
            return;
        }
        String property = environment.getProperty("spring.config.import");
        if (!StringUtils.hasText((String)property)) {
            throw new ImportException("No spring.config.import set", false);
        }
        if (!property.contains("consul:")) {
            throw new ImportException("spring.config.import missing consul:", true);
        }
    }

    static class ImportExceptionFailureAnalyzer
    extends AbstractFailureAnalyzer<ImportException> {
        ImportExceptionFailureAnalyzer() {
        }

        protected FailureAnalysis analyze(Throwable rootFailure, ImportException cause) {
            String description = cause.missingPrefix ? "The spring.config.import property is missing a consul: entry" : "No spring.config.import property has been defined";
            String action = "Add a spring.config.import=consul: property to your configuration.\n\tIf configuration is not required add spring.config.import=optional:consul: instead.\n\tTo disable this check, set spring.cloud.consul.config.enabled=false or \n\tspring.cloud.consul.config.import-check.enabled=false.";
            return new FailureAnalysis(description, action, (Throwable)cause);
        }
    }

    static class ImportException
    extends RuntimeException {
        final boolean missingPrefix;

        ImportException(String message, boolean missingPrefix) {
            super(message);
            this.missingPrefix = missingPrefix;
        }
    }
}

