/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.consul.config.ConsulBootstrapper;
import org.springframework.cloud.consul.config.ConsulConfigDataResource;
import org.springframework.cloud.consul.config.ConsulConfigIndexes;
import org.springframework.cloud.consul.config.ConsulPropertySource;

public class ConsulConfigDataLoader
implements ConfigDataLoader<ConsulConfigDataResource> {
    private final Log log;

    public ConsulConfigDataLoader(Log log) {
        this.log = log;
    }

    public ConfigData load(ConfigDataLoaderContext context, ConsulConfigDataResource resource) {
        ConsulBootstrapper.LoaderInterceptor interceptor;
        if (context.getBootstrapContext().isRegistered(ConsulBootstrapper.LoaderInterceptor.class) && (interceptor = (ConsulBootstrapper.LoaderInterceptor)context.getBootstrapContext().get(ConsulBootstrapper.LoaderInterceptor.class)) != null) {
            Binder binder = (Binder)context.getBootstrapContext().get(Binder.class);
            return (ConfigData)interceptor.apply(new ConsulBootstrapper.LoadContext(context, resource, binder, this::doLoad));
        }
        return this.doLoad(context, resource);
    }

    public ConfigData doLoad(ConfigDataLoaderContext context, ConsulConfigDataResource resource) {
        try {
            ConsulClient consul = this.getBean(context, ConsulClient.class);
            ConsulConfigIndexes indexes = this.getBean(context, ConsulConfigIndexes.class);
            ConsulPropertySource propertySource = resource.getConsulPropertySources().createPropertySource(resource.getContext(), consul, indexes.getIndexes()::put);
            if (propertySource == null) {
                return null;
            }
            return new ConfigData(Collections.singletonList(propertySource), new ConfigData.Option[0]);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Error getting properties from consul: " + (Object)((Object)resource)), (Throwable)e);
            }
            throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
        }
    }

    protected <T> T getBean(ConfigDataLoaderContext context, Class<T> type) {
        if (context.getBootstrapContext().isRegistered(type)) {
            return (T)context.getBootstrapContext().get(type);
        }
        return null;
    }
}

