/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.config.server.environment.AbstractVaultEnvironmentRepository;
import org.springframework.cloud.config.server.environment.ConfigTokenProvider;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.HttpRequestConfigTokenProvider;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategy;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategyFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Validated
public class VaultEnvironmentRepository
extends AbstractVaultEnvironmentRepository {
    private static final String VAULT_TOKEN = "X-Vault-Token";
    static final String VAULT_NAMESPACE = "X-Vault-Namespace";
    @NotEmpty
    private String host;
    @Min(value=1L)
    @Max(value=65535L)
    private @Min(value=1L) @Max(value=65535L) int port;
    private String scheme;
    @NotEmpty
    private String backend;
    private String namespace;
    private VaultKvAccessStrategy accessStrategy;
    private final ConfigTokenProvider tokenProvider;

    public VaultEnvironmentRepository(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, RestTemplate rest, VaultEnvironmentProperties properties) {
        this(request, watch, rest, properties, new HttpRequestConfigTokenProvider(request));
    }

    public VaultEnvironmentRepository(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, RestTemplate rest, VaultEnvironmentProperties properties, ConfigTokenProvider tokenProvider) {
        super(request, watch, properties);
        this.tokenProvider = tokenProvider;
        this.backend = properties.getBackend();
        this.host = properties.getHost();
        this.port = properties.getPort();
        this.scheme = properties.getScheme();
        this.namespace = properties.getNamespace();
        String baseUrl = String.format("%s://%s:%s", this.scheme, this.host, this.port);
        this.accessStrategy = VaultKvAccessStrategyFactory.forVersion((RestOperations)rest, baseUrl, properties.getKvVersion(), properties.getPathToKey());
    }

    void setAccessStrategy(VaultKvAccessStrategy accessStrategy) {
        this.accessStrategy = accessStrategy;
    }

    @Override
    protected String read(String key) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(VAULT_TOKEN, this.getToken());
        if (StringUtils.hasText((String)this.namespace)) {
            headers.add(VAULT_NAMESPACE, this.namespace);
        }
        return this.accessStrategy.getData(headers, this.backend, key);
    }

    private String getToken() {
        String token = this.tokenProvider.getToken();
        if (!StringUtils.hasLength((String)token)) {
            throw new IllegalArgumentException("A Vault token must be supplied by a token provider");
        }
        return token;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

