/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.io.File;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;

public class FileBasedSshSessionFactory
extends SshdSessionFactory {
    private final JGitEnvironmentProperties sshUriProperties;

    public FileBasedSshSessionFactory(JGitEnvironmentProperties sshUriProperties) {
        this.sshUriProperties = sshUriProperties;
    }

    protected SshConfigStore createSshConfigStore(File homeDir, File configFile, String localUserName) {
        return configFile == null ? null : new OpenSshConfigFile(homeDir, configFile, localUserName){

            public OpenSshConfigFile.HostEntry lookup(@NonNull String hostName, int port, String userName) {
                OpenSshConfigFile.HostEntry hostEntry = super.lookup(hostName, port, userName);
                hostEntry.setValue("StrictHostKeyChecking", FileBasedSshSessionFactory.this.sshUriProperties.isStrictHostKeyChecking() ? "yes" : "no");
                return hostEntry;
            }
        };
    }
}

