/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersByPathRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersByPathResult;
import com.amazonaws.services.simplesystemsmanagement.model.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

public class AwsParameterStoreEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private final AWSSimpleSystemsManagement awsSsmClient;
    private final ConfigServerProperties configServerProperties;
    private final AwsParameterStoreEnvironmentProperties environmentProperties;
    private final int order;

    public AwsParameterStoreEnvironmentRepository(AWSSimpleSystemsManagement awsSsmClient, ConfigServerProperties configServerProperties, AwsParameterStoreEnvironmentProperties environmentProperties) {
        this.awsSsmClient = awsSsmClient;
        this.configServerProperties = configServerProperties;
        this.environmentProperties = environmentProperties;
        this.order = environmentProperties.getOrder();
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        if (!StringUtils.hasLength((String)application)) {
            application = this.configServerProperties.getDefaultApplicationName();
        }
        if (!StringUtils.hasLength((String)profile)) {
            profile = this.configServerProperties.getDefaultProfile();
        }
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment result = new Environment(application, profiles, label, null, null);
        Set<String> paths = this.buildParameterPaths(application, profiles);
        List<PropertySource> propertySources = this.getPropertySources(paths);
        result.addAll(propertySources);
        return result;
    }

    private Set<String> buildParameterPaths(String application, String[] profiles) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String prefix = this.environmentProperties.getPrefix();
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String profileSeparator = this.environmentProperties.getProfileSeparator();
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        List orderedProfiles = Stream.concat(Arrays.stream(profiles).filter(p -> !p.equals(defaultProfile)), Arrays.stream(new String[]{defaultProfile})).collect(Collectors.toList());
        if (application.equals(defaultApplication)) {
            for (String profile : orderedProfiles) {
                result.add(prefix + "/" + defaultApplication + profileSeparator + profile + "/");
            }
        } else {
            for (String profile : orderedProfiles) {
                result.add(prefix + "/" + application + profileSeparator + profile + "/");
                result.add(prefix + "/" + defaultApplication + profileSeparator + profile + "/");
            }
            result.add(prefix + "/" + application + "/");
        }
        result.add(prefix + "/" + defaultApplication + "/");
        return result;
    }

    private List<PropertySource> getPropertySources(Set<String> parameterPaths) {
        ArrayList<PropertySource> result = new ArrayList<PropertySource>();
        for (String path : parameterPaths) {
            String name = this.environmentProperties.getOrigin() + path;
            Map<String, String> source = this.getPropertiesByParameterPath(path);
            if (source.isEmpty()) continue;
            result.add(new PropertySource(name, source));
        }
        Map<String, String> overrides = this.configServerProperties.getOverrides();
        if (!overrides.isEmpty()) {
            result.add(0, new PropertySource("overrides", overrides));
        }
        return result;
    }

    private Map<String, String> getPropertiesByParameterPath(String path) {
        HashMap<String, String> result = new HashMap<String, String>();
        GetParametersByPathRequest request = new GetParametersByPathRequest().withPath(path).withRecursive(Boolean.valueOf(this.environmentProperties.isRecursive())).withWithDecryption(Boolean.valueOf(this.environmentProperties.isDecryptValues())).withMaxResults(Integer.valueOf(this.environmentProperties.getMaxResults()));
        GetParametersByPathResult response = this.awsSsmClient.getParametersByPath(request);
        if (response != null) {
            this.addParametersToProperties(path, response.getParameters(), result);
            while (StringUtils.hasLength((String)response.getNextToken())) {
                response = this.awsSsmClient.getParametersByPath(request.withNextToken(response.getNextToken()));
                this.addParametersToProperties(path, response.getParameters(), result);
            }
        }
        return result;
    }

    private void addParametersToProperties(String path, List<Parameter> parameters, Map<String, String> properties) {
        for (Parameter parameter : parameters) {
            String name = StringUtils.delete((String)parameter.getName(), (String)path).replace("/", ".");
            properties.put(name, parameter.getValue());
        }
    }

    public int getOrder() {
        return this.order;
    }
}

