/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectIdBuilder;
import java.io.InputStream;
import java.util.Map;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.JsonS3ConfigFile;
import org.springframework.cloud.config.server.environment.NoSuchRepositoryException;
import org.springframework.cloud.config.server.environment.PropertyS3ConfigFile;
import org.springframework.cloud.config.server.environment.S3ConfigFile;
import org.springframework.cloud.config.server.environment.YamlS3ConfigFile;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

public class AwsS3EnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private final AmazonS3 s3Client;
    private final String bucketName;
    private final ConfigServerProperties serverProperties;
    protected int order = Integer.MAX_VALUE;

    public AwsS3EnvironmentRepository(AmazonS3 s3Client, String bucketName, ConfigServerProperties server) {
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        this.serverProperties = server;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public Environment findOne(String specifiedApplication, String specifiedProfile, String specifiedLabel) {
        String application = StringUtils.isEmpty((Object)specifiedApplication) ? this.serverProperties.getDefaultApplicationName() : specifiedApplication;
        String profile = StringUtils.isEmpty((Object)specifiedProfile) ? this.serverProperties.getDefaultProfile() : specifiedProfile;
        String label = StringUtils.isEmpty((Object)specifiedLabel) ? this.serverProperties.getDefaultLabel() : specifiedLabel;
        StringBuilder objectKeyPrefix = new StringBuilder();
        if (!StringUtils.isEmpty((Object)label)) {
            objectKeyPrefix.append(label).append("/");
        }
        objectKeyPrefix.append(application).append("-").append(profile);
        Environment environment = new Environment(application, new String[]{profile});
        environment.setLabel(label);
        S3ObjectIdBuilder s3ObjectIdBuilder = new S3ObjectIdBuilder().withBucket(this.bucketName);
        S3ConfigFile s3ConfigFile = this.getS3ConfigFile(s3ObjectIdBuilder, objectKeyPrefix.toString());
        if (s3ConfigFile == null) {
            throw new NoSuchRepositoryException("No such repository: (" + s3ObjectIdBuilder.withKey(objectKeyPrefix.toString() + "(.properties | .yml | .json)").build().toString() + ")");
        }
        environment.setVersion(s3ConfigFile.getVersion());
        Map<?, ?> config = s3ConfigFile.read();
        config.putAll(this.serverProperties.getOverrides());
        environment.add(new PropertySource(application, config));
        return environment;
    }

    private S3ConfigFile getS3ConfigFile(S3ObjectIdBuilder s3ObjectIdBuilder, String keyPrefix) {
        try {
            S3Object properties = this.s3Client.getObject(new GetObjectRequest(s3ObjectIdBuilder.withKey(keyPrefix + ".properties").build()));
            return new PropertyS3ConfigFile(properties.getObjectMetadata().getVersionId(), (InputStream)properties.getObjectContent());
        }
        catch (Exception eProperties) {
            try {
                S3Object yaml = this.s3Client.getObject(new GetObjectRequest(s3ObjectIdBuilder.withKey(keyPrefix + ".yml").build()));
                return new YamlS3ConfigFile(yaml.getObjectMetadata().getVersionId(), (InputStream)yaml.getObjectContent());
            }
            catch (Exception eYaml) {
                try {
                    S3Object json = this.s3Client.getObject(new GetObjectRequest(s3ObjectIdBuilder.withKey(keyPrefix + ".json").build()));
                    return new JsonS3ConfigFile(json.getObjectMetadata().getVersionId(), (InputStream)json.getObjectContent());
                }
                catch (Exception eJson) {
                    return null;
                }
            }
        }
    }
}

