/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.util.ArrayList;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class GitSkipSslValidationCredentialsProvider
extends CredentialsProvider {
    private final CredentialsProvider delegate;

    public GitSkipSslValidationCredentialsProvider(CredentialsProvider delegate) {
        this.delegate = delegate;
    }

    public static boolean canHandle(String uri) {
        return uri != null && uri.toLowerCase().startsWith("https://");
    }

    public boolean isInteractive() {
        return this.delegate != null && this.delegate.isInteractive();
    }

    public boolean supports(CredentialItem ... items) {
        ArrayList<CredentialItem> unprocessedItems = new ArrayList<CredentialItem>();
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.InformationalMessage && item.getPromptText() != null && item.getPromptText().contains(JGitText.get().sslFailureTrustExplanation) || item instanceof CredentialItem.YesNoType && item.getPromptText() != null && (item.getPromptText().equals(JGitText.get().sslTrustNow) || item.getPromptText().startsWith(GitSkipSslValidationCredentialsProvider.stripFormattingPlaceholders(JGitText.get().sslTrustForRepo)) || item.getPromptText().equals(JGitText.get().sslTrustAlways))) continue;
            unprocessedItems.add(item);
        }
        return unprocessedItems.isEmpty() || this.delegate != null && this.delegate.supports(unprocessedItems.toArray(new CredentialItem[0]));
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        ArrayList<CredentialItem> unprocessedItems = new ArrayList<CredentialItem>();
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.YesNoType) {
                CredentialItem.YesNoType yesNoItem = (CredentialItem.YesNoType)item;
                String prompt = yesNoItem.getPromptText();
                if (prompt == null) {
                    unprocessedItems.add(item);
                    continue;
                }
                if (prompt.equals(JGitText.get().sslTrustNow) || prompt.startsWith(GitSkipSslValidationCredentialsProvider.stripFormattingPlaceholders(JGitText.get().sslTrustForRepo))) {
                    yesNoItem.setValue(true);
                    continue;
                }
                if (prompt.equals(JGitText.get().sslTrustAlways)) {
                    yesNoItem.setValue(false);
                    continue;
                }
                unprocessedItems.add(item);
                continue;
            }
            if (item.getPromptText().contains(JGitText.get().sslFailureTrustExplanation)) continue;
            unprocessedItems.add(item);
        }
        if (unprocessedItems.isEmpty()) {
            return true;
        }
        if (this.delegate != null) {
            return this.delegate.get(uri, unprocessedItems.toArray(new CredentialItem[0]));
        }
        throw new UnsupportedCredentialItem(uri, unprocessedItems.size() + " credential items not supported");
    }

    public void reset(URIish uri) {
        if (this.delegate != null) {
            this.delegate.reset(uri);
        }
    }

    private static String stripFormattingPlaceholders(String string) {
        return string.replaceAll("\\s*\\{\\d}\\s*", "");
    }
}

