/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.Optional;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository;
import org.springframework.cloud.config.server.ssh.FileBasedSshTransportConfigCallback;
import org.springframework.cloud.config.server.ssh.PropertiesBasedSshTransportConfigCallback;
import org.springframework.core.env.ConfigurableEnvironment;

public class MultipleJGitEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<MultipleJGitEnvironmentRepository, MultipleJGitEnvironmentProperties> {
    private ConfigurableEnvironment environment;
    private ConfigServerProperties server;
    private Optional<TransportConfigCallback> customTransportConfigCallback;

    public MultipleJGitEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties server, Optional<TransportConfigCallback> customTransportConfigCallback) {
        this.environment = environment;
        this.server = server;
        this.customTransportConfigCallback = customTransportConfigCallback;
    }

    @Override
    public MultipleJGitEnvironmentRepository build(MultipleJGitEnvironmentProperties environmentProperties) {
        MultipleJGitEnvironmentRepository repository = new MultipleJGitEnvironmentRepository(this.environment, environmentProperties);
        repository.setTransportConfigCallback(this.customTransportConfigCallback.orElse(this.buildTransportConfigCallback(environmentProperties)));
        if (this.server.getDefaultLabel() != null) {
            repository.setDefaultLabel(this.server.getDefaultLabel());
        }
        return repository;
    }

    private TransportConfigCallback buildTransportConfigCallback(MultipleJGitEnvironmentProperties gitEnvironmentProperties) {
        if (gitEnvironmentProperties.isIgnoreLocalSshSettings()) {
            return new PropertiesBasedSshTransportConfigCallback(gitEnvironmentProperties);
        }
        return new FileBasedSshTransportConfigCallback(gitEnvironmentProperties);
    }
}

