/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.config.server.composite.CompositeEnvironmentBeanFactoryPostProcessor;
import org.springframework.cloud.config.server.composite.ConditionalOnMissingSearchPathLocator;
import org.springframework.cloud.config.server.composite.ConditionalOnSearchPathLocator;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.CompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.SearchPathCompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SvnEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.VaultEnvironmentRepositoryFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.tmatesoft.svn.core.SVNException;

@Configuration
@Profile(value={"composite"})
class CompositeRepositoryConfiguration {
    CompositeRepositoryConfiguration() {
    }

    @Bean
    public VaultEnvironmentRepositoryFactory vaultEnvironmentRepositoryFactory(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch) {
        return new VaultEnvironmentRepositoryFactory(request, watch);
    }

    @Bean
    public NativeEnvironmentRepositoryFactory nativeEnvironmentRepositoryFactory(ConfigurableEnvironment environment) {
        return new NativeEnvironmentRepositoryFactory(environment);
    }

    @Bean
    public static CompositeEnvironmentBeanFactoryPostProcessor compositeEnvironmentRepositoryBeanFactoryPostProcessor(Environment environment) {
        return new CompositeEnvironmentBeanFactoryPostProcessor(environment);
    }

    @Primary
    @Bean
    @ConditionalOnSearchPathLocator
    public SearchPathCompositeEnvironmentRepository searchPathCompositeEnvironmentRepository(List<EnvironmentRepository> environmentRepositories) throws Exception {
        return new SearchPathCompositeEnvironmentRepository(environmentRepositories);
    }

    @Primary
    @Bean
    @ConditionalOnMissingSearchPathLocator
    public CompositeEnvironmentRepository compositeEnvironmentRepository(List<EnvironmentRepository> environmentRepositories) throws Exception {
        return new CompositeEnvironmentRepository(environmentRepositories);
    }

    @Configuration
    @ConditionalOnClass(value={JdbcTemplate.class})
    static class JdbcCompositeConfig {
        JdbcCompositeConfig() {
        }

        @Bean
        public JdbcEnvironmentRepositoryFactory jdbcEnvironmentRepositoryFactory(JdbcTemplate jdbc) {
            return new JdbcEnvironmentRepositoryFactory(jdbc);
        }
    }

    @Configuration
    @ConditionalOnClass(value={SVNException.class})
    static class SvnCompositeConfig {
        SvnCompositeConfig() {
        }

        @Bean
        public SvnEnvironmentRepositoryFactory svnEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties server) {
            return new SvnEnvironmentRepositoryFactory(environment, server);
        }
    }

    @Configuration
    @ConditionalOnClass(value={TransportConfigCallback.class})
    static class JGitCompositeConfig {
        JGitCompositeConfig() {
        }

        @Bean
        public MultipleJGitEnvironmentRepositoryFactory gitEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties server, Optional<TransportConfigCallback> customTransportConfigCallback) {
            return new MultipleJGitEnvironmentRepositoryFactory(environment, server, customTransportConfigCallback);
        }
    }
}

