/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.bootstrap.encrypt.RsaProperties;
import org.springframework.cloud.bootstrap.encrypt.TextEncryptorUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigClientRequestTemplateFactory;
import org.springframework.cloud.config.client.ConfigClientRetryBootstrapper;
import org.springframework.cloud.config.client.ConfigServerConfigDataResource;
import org.springframework.cloud.config.client.ConfigServerInstanceMonitor;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.config.client.RetryProperties;
import org.springframework.cloud.config.client.RetryTemplateFactory;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogMessage;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class ConfigServerConfigDataLocationResolver
implements ConfigDataLocationResolver<ConfigServerConfigDataResource>,
Ordered {
    public static final String PREFIX = "configserver:";
    static final boolean RSA_IS_PRESENT = ClassUtils.isPresent((String)"org.springframework.security.crypto.encrypt.RsaSecretEncryptor", null);
    private final Log log;

    public ConfigServerConfigDataLocationResolver(DeferredLogFactory factory) {
        this.log = factory.getLog(ConfigServerConfigDataLocationResolver.class);
    }

    public int getOrder() {
        return -1;
    }

    protected void setTextEncryptorDelegate(ConfigDataLocationResolverContext context) {
        if (context.getBootstrapContext().isRegistered(TextEncryptor.class)) {
            TextEncryptor textEncryptor;
            Binder binder = context.getBinder();
            KeyProperties keyProperties = (KeyProperties)binder.bindOrCreate("encrypt", Bindable.of(KeyProperties.class));
            boolean textEncryptorRegistered = context.getBootstrapContext().isRegistered(TextEncryptor.class);
            if (TextEncryptorUtils.keysConfigured((KeyProperties)keyProperties) && textEncryptorRegistered && (textEncryptor = (TextEncryptor)context.getBootstrapContext().get(TextEncryptor.class)) instanceof TextEncryptorUtils.FailsafeTextEncryptor) {
                TextEncryptor delegate;
                TextEncryptorUtils.FailsafeTextEncryptor failsafeTextEncryptor = (TextEncryptorUtils.FailsafeTextEncryptor)textEncryptor;
                if (RSA_IS_PRESENT) {
                    RsaProperties rsaProperties = (RsaProperties)binder.bindOrCreate("encrypt.rsa", Bindable.of(RsaProperties.class));
                    delegate = TextEncryptorUtils.createTextEncryptor((KeyProperties)keyProperties, (RsaProperties)rsaProperties);
                } else {
                    delegate = new EncryptorFactory(keyProperties.getSalt()).create(keyProperties.getKey());
                }
                failsafeTextEncryptor.setDelegate(delegate);
            }
        }
    }

    protected PropertyHolder loadProperties(ConfigDataLocationResolverContext context, String uris) {
        ConfigClientProperties configClientProperties;
        Binder binder = context.getBinder();
        BindHandler bindHandler = this.getBindHandler(context);
        if (context.getBootstrapContext().isRegistered(ConfigClientProperties.class)) {
            configClientProperties = (ConfigClientProperties)binder.bind("spring.cloud.config", Bindable.of(ConfigClientProperties.class), bindHandler).orElseGet(ConfigClientProperties::new);
            boolean discoveryEnabled = (Boolean)context.getBinder().bind("spring.cloud.config.discovery.enabled", Bindable.of(Boolean.class), this.getBindHandler(context)).orElse((Object)false);
            if (discoveryEnabled) {
                ConfigServerInstanceMonitor instanceMonitor = (ConfigServerInstanceMonitor)context.getBootstrapContext().get(ConfigServerInstanceMonitor.class);
                configClientProperties.setUri(instanceMonitor.getUri());
                configClientProperties.setPassword(instanceMonitor.getPassword());
                configClientProperties.setUsername(instanceMonitor.getUsername());
            }
        } else {
            configClientProperties = (ConfigClientProperties)binder.bind("spring.cloud.config", Bindable.of(ConfigClientProperties.class), bindHandler).orElseGet(ConfigClientProperties::new);
        }
        if (!StringUtils.hasText((String)configClientProperties.getName()) || "application".equals(configClientProperties.getName())) {
            String applicationName = (String)binder.bind("spring.application.name", Bindable.of(String.class), bindHandler).orElse((Object)"application");
            configClientProperties.setName(applicationName);
        }
        PropertyHolder holder = new PropertyHolder();
        holder.properties = configClientProperties;
        holder.retryProperties = (RetryProperties)binder.bind("spring.cloud.config.retry", RetryProperties.class).orElseGet(RetryProperties::new);
        if (StringUtils.hasText((String)uris)) {
            Properties properties;
            String[] uri = StringUtils.commaDelimitedListToStringArray((String)uris);
            String paramStr = null;
            for (int i = 0; i < uri.length; ++i) {
                int paramIdx = uri[i].indexOf(63);
                if (paramIdx <= 0) continue;
                if (i == 0) {
                    paramStr = uri[i].substring(paramIdx + 1);
                }
                uri[i] = uri[i].substring(0, paramIdx);
            }
            if (StringUtils.hasText(paramStr) && (properties = StringUtils.splitArrayElementsIntoProperties((String[])StringUtils.delimitedListToStringArray(paramStr, (String)"&"), (String)"=")) != null) {
                PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
                map.from(() -> properties.getProperty("fail-fast")).as(Boolean::valueOf).to(configClientProperties::setFailFast);
                map.from(() -> properties.getProperty("max-attempts")).as(Integer::valueOf).to(holder.retryProperties::setMaxAttempts);
                map.from(() -> properties.getProperty("max-interval")).as(Long::valueOf).to(holder.retryProperties::setMaxInterval);
                map.from(() -> properties.getProperty("multiplier")).as(Double::valueOf).to(holder.retryProperties::setMultiplier);
                map.from(() -> properties.getProperty("initial-interval")).as(Long::valueOf).to(holder.retryProperties::setInitialInterval);
            }
            configClientProperties.setUri(uri);
        }
        return holder;
    }

    private BindHandler getBindHandler(ConfigDataLocationResolverContext context) {
        return (BindHandler)context.getBootstrapContext().getOrElse(BindHandler.class, null);
    }

    protected Log getLog() {
        return this.log;
    }

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        if (!location.hasPrefix(this.getPrefix())) {
            return false;
        }
        return (Boolean)context.getBinder().bind("spring.cloud.config.enabled", Boolean.class).orElse((Object)true);
    }

    protected String getPrefix() {
        return PREFIX;
    }

    public List<ConfigServerConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        return this.resolveProfileSpecific(context, location, null);
    }

    public List<ConfigServerConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        this.setTextEncryptorDelegate(resolverContext);
        String uris = location.getNonPrefixedValue(this.getPrefix());
        PropertyHolder propertyHolder = this.loadProperties(resolverContext, uris);
        ConfigClientProperties properties = propertyHolder.properties;
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        bootstrapContext.register(ConfigClientProperties.class, BootstrapRegistry.InstanceSupplier.of((Object)properties).withScope(BootstrapRegistry.Scope.PROTOTYPE));
        bootstrapContext.addCloseListener(event -> event.getApplicationContext().getBeanFactory().registerSingleton("configDataConfigClientProperties", event.getBootstrapContext().get(ConfigClientProperties.class)));
        bootstrapContext.registerIfAbsent(ConfigClientRequestTemplateFactory.class, context -> new ConfigClientRequestTemplateFactory(this.log, (ConfigClientProperties)context.get(ConfigClientProperties.class)));
        bootstrapContext.registerIfAbsent(RestTemplate.class, context -> {
            ConfigClientRequestTemplateFactory factory = (ConfigClientRequestTemplateFactory)context.get(ConfigClientRequestTemplateFactory.class);
            return factory.create();
        });
        bootstrapContext.registerIfAbsent(PropertyResolver.class, context -> new PropertyResolver(resolverContext.getBinder(), this.getBindHandler(resolverContext)));
        ConfigServerConfigDataResource resource = new ConfigServerConfigDataResource(properties, location.isOptional(), profiles);
        resource.setProfileSpecific(!ObjectUtils.isEmpty((Object)profiles));
        resource.setLog(this.log);
        resource.setRetryProperties(propertyHolder.retryProperties);
        boolean discoveryEnabled = (Boolean)resolverContext.getBinder().bind("spring.cloud.config.discovery.enabled", Bindable.of(Boolean.class), this.getBindHandler(resolverContext)).orElse((Object)false);
        boolean retryEnabled = (Boolean)resolverContext.getBinder().bind("spring.cloud.config.fail-fast", Bindable.of(Boolean.class), this.getBindHandler(resolverContext)).orElse((Object)false);
        if (discoveryEnabled) {
            this.log.debug((Object)LogMessage.format((String)"discovery enabled", (Object[])new Object[0]));
            bootstrapContext.registerIfAbsent(ConfigServerInstanceMonitor.class, context -> {
                ConfigServerInstanceProvider instanceProvider;
                ConfigServerInstanceProvider.Function function = (ConfigServerInstanceProvider.Function)context.get(ConfigServerInstanceProvider.Function.class);
                if (ConfigClientRetryBootstrapper.RETRY_IS_PRESENT && retryEnabled) {
                    this.log.debug((Object)LogMessage.format((String)"discovery plus retry enabled", (Object[])new Object[0]));
                    final RetryTemplate retryTemplate = RetryTemplateFactory.create(propertyHolder.retryProperties, this.log);
                    instanceProvider = new ConfigServerInstanceProvider(function, resolverContext.getBinder(), this.getBindHandler(resolverContext)){

                        @Override
                        public List<ServiceInstance> getConfigServerInstances(String serviceId) {
                            return (List)retryTemplate.execute(retryContext -> super.getConfigServerInstances(serviceId));
                        }
                    };
                } else {
                    instanceProvider = new ConfigServerInstanceProvider(function, resolverContext.getBinder(), this.getBindHandler(resolverContext));
                }
                instanceProvider.setLog(this.log);
                ConfigClientProperties clientProperties = (ConfigClientProperties)context.get(ConfigClientProperties.class);
                ConfigServerInstanceMonitor instanceMonitor = new ConfigServerInstanceMonitor(this.log, clientProperties, instanceProvider);
                instanceMonitor.setRefreshOnStartup(false);
                instanceMonitor.refresh();
                return instanceMonitor;
            });
            bootstrapContext.addCloseListener(event -> {
                ConfigServerInstanceMonitor configServerInstanceMonitor = (ConfigServerInstanceMonitor)event.getBootstrapContext().get(ConfigServerInstanceMonitor.class);
                event.getApplicationContext().getBeanFactory().registerSingleton("configServerInstanceMonitor", (Object)configServerInstanceMonitor);
            });
        }
        ArrayList<ConfigServerConfigDataResource> locations = new ArrayList<ConfigServerConfigDataResource>();
        locations.add(resource);
        return locations;
    }

    private class PropertyHolder {
        ConfigClientProperties properties;
        RetryProperties retryProperties;

        private PropertyHolder() {
        }
    }

    public static class PropertyResolver {
        private final Binder binder;
        private final BindHandler bindHandler;

        public PropertyResolver(Binder binder, BindHandler bindHandler) {
            this.binder = binder;
            this.bindHandler = bindHandler;
        }

        public <T> T get(String key, Class<T> type, T defaultValue) {
            return (T)this.binder.bind(key, Bindable.of(type)).orElse(defaultValue);
        }

        public <T> T resolveConfigurationProperties(String prefix, Class<T> type, Supplier<T> defaultValue) {
            return (T)this.binder.bind(prefix, Bindable.of(type), this.bindHandler).orElseGet(defaultValue);
        }

        public <T> T resolveOrCreateConfigurationProperties(String prefix, Class<T> type) {
            return (T)this.binder.bindOrCreate(prefix, Bindable.of(type), this.bindHandler);
        }
    }
}

