/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.net.URI;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.http.client.autoconfigure.HttpClientProperties;
import org.springframework.boot.http.client.autoconfigure.service.HttpServiceClientProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.reactive.DeferringLoadBalancerExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancedExchangeFilterFunction;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.support.WebClientHttpServiceGroupConfigurer;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;
import org.springframework.web.util.UriComponentsBuilder;

public class LoadBalancerWebClientHttpServiceGroupConfigurer
implements WebClientHttpServiceGroupConfigurer {
    private static final int ORDER = 10;
    private final SingletonSupplier<DeferringLoadBalancerExchangeFilterFunction<LoadBalancedExchangeFilterFunction>> loadBalancerFilterFunctionSupplier = SingletonSupplier.ofNullable(() -> exchangeFilterFunctionProvider.getIfAvailable());
    private final HttpServiceClientProperties httpServiceClientProperties;

    public LoadBalancerWebClientHttpServiceGroupConfigurer(ObjectProvider<DeferringLoadBalancerExchangeFilterFunction<LoadBalancedExchangeFilterFunction>> exchangeFilterFunctionProvider, HttpServiceClientProperties httpServiceClientProperties) {
        this.httpServiceClientProperties = httpServiceClientProperties;
    }

    public void configureGroups(HttpServiceGroupConfigurer.Groups<WebClient.Builder> groups) {
        DeferringLoadBalancerExchangeFilterFunction loadBalancerFilterFunction = (DeferringLoadBalancerExchangeFilterFunction)this.loadBalancerFilterFunctionSupplier.get();
        if (loadBalancerFilterFunction == null) {
            throw new IllegalStateException(DeferringLoadBalancerExchangeFilterFunction.class.getSimpleName() + " bean not available.");
        }
        groups.forEachGroup((group, clientBuilder, factoryBuilder) -> {
            URI existingBaseUrl;
            String groupName = group.name();
            HttpClientProperties groupProperties = this.httpServiceClientProperties.get(groupName);
            String baseUrlString = groupProperties == null ? null : groupProperties.getBaseUrl();
            URI uRI = existingBaseUrl = baseUrlString == null ? null : URI.create(baseUrlString);
            if (existingBaseUrl == null) {
                URI baseUrl = this.constructBaseUrl(groupName);
                clientBuilder.baseUrl(String.valueOf(baseUrl));
                clientBuilder.filter((ExchangeFilterFunction)loadBalancerFilterFunction);
            } else if ("lb".equalsIgnoreCase(existingBaseUrl.getScheme())) {
                String baseUrl = UriComponentsBuilder.fromUri((URI)existingBaseUrl).scheme("http").build().toUriString();
                clientBuilder.baseUrl(baseUrl);
                clientBuilder.filter((ExchangeFilterFunction)loadBalancerFilterFunction);
            }
        });
    }

    public int getOrder() {
        return 10;
    }

    private URI constructBaseUrl(String groupName) {
        return LoadBalancerUriTools.constructInterfaceClientsBaseUrl(groupName);
    }
}

