/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health.reactive;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.health.contributor.CompositeReactiveHealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributors;
import org.springframework.boot.health.contributor.ReactiveHealthIndicator;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryHealthIndicator;
import org.springframework.util.Assert;

public class ReactiveDiscoveryCompositeHealthContributor
implements CompositeReactiveHealthContributor {
    private Map<String, ReactiveDiscoveryHealthIndicator> indicators;

    public ReactiveDiscoveryCompositeHealthContributor(Collection<ReactiveDiscoveryHealthIndicator> indicators) {
        Assert.notNull(indicators, (String)"'indicators' must not be null");
        this.indicators = indicators.stream().collect(Collectors.toMap(ReactiveDiscoveryHealthIndicator::getName, Function.identity()));
    }

    public Stream<ReactiveHealthContributors.Entry> stream() {
        return this.indicators.entrySet().stream().map(entry -> new ReactiveHealthContributors.Entry((String)entry.getKey(), (ReactiveHealthContributor)this.asHealthIndicator((ReactiveDiscoveryHealthIndicator)entry.getValue())));
    }

    public ReactiveHealthContributor getContributor(String name) {
        return this.asHealthIndicator(this.indicators.get(name));
    }

    private ReactiveHealthIndicator asHealthIndicator(ReactiveDiscoveryHealthIndicator indicator) {
        return indicator != null ? indicator::health : null;
    }
}

