/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.web.util.UriComponentsBuilder;

public final class LoadBalancerUriTools {
    private static final String PERCENTAGE_SIGN = "%";
    private static final String DEFAULT_SECURE_SCHEME = "https";
    private static final Map<String, String> INSECURE_SCHEME_MAPPINGS = new HashMap<String, String>();
    public static final String DEFAULT_SCHEME = "http";

    private LoadBalancerUriTools() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    private static boolean containsEncodedParts(URI uri) {
        boolean encoded;
        boolean bl = encoded = uri.getRawQuery() != null && uri.getRawQuery().contains(PERCENTAGE_SIGN) || uri.getRawPath() != null && uri.getRawPath().contains(PERCENTAGE_SIGN) || uri.getRawFragment() != null && uri.getRawFragment().contains(PERCENTAGE_SIGN);
        if (encoded) {
            try {
                UriComponentsBuilder.fromUri((URI)uri).build(true);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        return false;
    }

    private static int computePort(int port, String scheme) {
        if (port >= 0) {
            return port;
        }
        if (Objects.equals(scheme, DEFAULT_SECURE_SCHEME)) {
            return 443;
        }
        return 80;
    }

    public static URI reconstructURI(ServiceInstance serviceInstance, URI original) {
        if (serviceInstance == null) {
            throw new IllegalArgumentException("Service Instance cannot be null.");
        }
        return LoadBalancerUriTools.doReconstructURI(serviceInstance, original);
    }

    private static URI doReconstructURI(ServiceInstance serviceInstance, URI original) {
        String host = serviceInstance.getHost();
        String scheme = Optional.ofNullable(serviceInstance.getScheme()).orElse(LoadBalancerUriTools.computeScheme(original, serviceInstance));
        int port = LoadBalancerUriTools.computePort(serviceInstance.getPort(), scheme);
        if (Objects.equals(host, original.getHost()) && port == original.getPort() && Objects.equals(scheme, original.getScheme())) {
            return original;
        }
        boolean encoded = LoadBalancerUriTools.containsEncodedParts(original);
        return UriComponentsBuilder.fromUri((URI)original).scheme(scheme).host(host).port(port).build(encoded).toUri();
    }

    private static String computeScheme(URI original, ServiceInstance serviceInstance) {
        String originalOrDefault = Optional.ofNullable(original.getScheme()).orElse(DEFAULT_SCHEME);
        if (serviceInstance.isSecure() && INSECURE_SCHEME_MAPPINGS.containsKey(originalOrDefault)) {
            return INSECURE_SCHEME_MAPPINGS.get(originalOrDefault);
        }
        return originalOrDefault;
    }

    public static URI constructInterfaceClientsBaseUrl(String groupName) {
        return UriComponentsBuilder.newInstance().scheme(DEFAULT_SCHEME).host(groupName).encode().build().toUri();
    }

    static {
        INSECURE_SCHEME_MAPPINGS.put(DEFAULT_SCHEME, DEFAULT_SECURE_SCHEME);
        INSECURE_SCHEME_MAPPINGS.put("ws", "wss");
    }
}

