/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.core.style.ToStringCreator;

public class CompletionContext<RES, T> {
    private final Status status;
    private final Throwable throwable;
    private final Response<T> loadBalancerResponse;
    private final RES clientResponse;

    public CompletionContext(Status status) {
        this(status, null, null, null);
    }

    public CompletionContext(Status status, Response<T> response) {
        this(status, null, response, null);
    }

    public CompletionContext(Status status, Throwable throwable, Response<T> loadBalancerResponse) {
        this(status, throwable, loadBalancerResponse, null);
    }

    public CompletionContext(Status status, Response<T> loadBalancerResponse, RES clientResponse) {
        this(status, null, loadBalancerResponse, clientResponse);
    }

    public CompletionContext(Status status, Throwable throwable, Response<T> loadBalancerResponse, RES clientResponse) {
        this.status = status;
        this.throwable = throwable;
        this.loadBalancerResponse = loadBalancerResponse;
        this.clientResponse = clientResponse;
    }

    public Status status() {
        return this.status;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Response<T> getLoadBalancerResponse() {
        return this.loadBalancerResponse;
    }

    public RES getClientResponse() {
        return this.clientResponse;
    }

    public String toString() {
        ToStringCreator to = new ToStringCreator((Object)this);
        to.append("status", (Object)this.status);
        to.append("throwable", (Object)this.throwable);
        to.append("loadBalancerResponse", this.loadBalancerResponse);
        to.append("clientResponse", this.clientResponse);
        return to.toString();
    }

    public static enum Status {
        SUCCESS,
        FAILED,
        DISCARD;

    }
}

