/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.LinkedCaseInsensitiveMap;

@ConfigurationProperties(value="spring.cloud.loadbalancer")
public class LoadBalancerProperties {
    private HealthCheck healthCheck = new HealthCheck();
    private Map<String, String> hint = new LinkedCaseInsensitiveMap();
    private Retry retry = new Retry();

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public Map<String, String> getHint() {
        return this.hint;
    }

    public void setHint(Map<String, String> hint) {
        this.hint = hint;
    }

    public Retry getRetry() {
        return this.retry;
    }

    public void setRetry(Retry retry) {
        this.retry = retry;
    }

    public static class Retry {
        private boolean enabled = true;
        private boolean retryOnAllOperations = false;
        private int maxRetriesOnSameServiceInstance = 0;
        private int maxRetriesOnNextServiceInstance = 1;
        private Set<Integer> retryableStatusCodes = new HashSet<Integer>();
        private Backoff backoff = new Backoff();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isRetryOnAllOperations() {
            return this.retryOnAllOperations;
        }

        public void setRetryOnAllOperations(boolean retryOnAllOperations) {
            this.retryOnAllOperations = retryOnAllOperations;
        }

        public int getMaxRetriesOnSameServiceInstance() {
            return this.maxRetriesOnSameServiceInstance;
        }

        public void setMaxRetriesOnSameServiceInstance(int maxRetriesOnSameServiceInstance) {
            this.maxRetriesOnSameServiceInstance = maxRetriesOnSameServiceInstance;
        }

        public int getMaxRetriesOnNextServiceInstance() {
            return this.maxRetriesOnNextServiceInstance;
        }

        public void setMaxRetriesOnNextServiceInstance(int maxRetriesOnNextServiceInstance) {
            this.maxRetriesOnNextServiceInstance = maxRetriesOnNextServiceInstance;
        }

        public Set<Integer> getRetryableStatusCodes() {
            return this.retryableStatusCodes;
        }

        public void setRetryableStatusCodes(Set<Integer> retryableStatusCodes) {
            this.retryableStatusCodes = retryableStatusCodes;
        }

        public Backoff getBackoff() {
            return this.backoff;
        }

        public void setBackoff(Backoff backoff) {
            this.backoff = backoff;
        }

        public static class Backoff {
            private boolean enabled = false;
            private Duration minBackoff = Duration.ofMillis(5L);
            private Duration maxBackoff = Duration.ofMillis(Long.MAX_VALUE);
            private double jitter = 0.5;

            public Duration getMinBackoff() {
                return this.minBackoff;
            }

            public void setMinBackoff(Duration minBackoff) {
                this.minBackoff = minBackoff;
            }

            public Duration getMaxBackoff() {
                return this.maxBackoff;
            }

            public void setMaxBackoff(Duration maxBackoff) {
                this.maxBackoff = maxBackoff;
            }

            public double getJitter() {
                return this.jitter;
            }

            public void setJitter(double jitter) {
                this.jitter = jitter;
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }

    public static class HealthCheck {
        private Duration initialDelay = Duration.ZERO;
        private Duration interval = Duration.ofSeconds(25L);
        private Map<String, String> path = new LinkedCaseInsensitiveMap();

        public Duration getInitialDelay() {
            return this.initialDelay;
        }

        public void setInitialDelay(Duration initialDelay) {
            this.initialDelay = initialDelay;
        }

        public Map<String, String> getPath() {
            return this.path;
        }

        public void setPath(Map<String, String> path) {
            this.path = path;
        }

        public Duration getInterval() {
            return this.interval;
        }

        public void setInterval(Duration interval) {
            this.interval = interval;
        }
    }
}

