/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.cloud.client.discovery.DiscoveryLifecycle;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;

public abstract class AbstractDiscoveryLifecycle
implements DiscoveryLifecycle,
ApplicationContextAware,
ApplicationListener<EmbeddedServletContainerInitializedEvent> {
    private static final Log logger = LogFactory.getLog(AbstractDiscoveryLifecycle.class);
    private boolean autoStartup = true;
    private AtomicBoolean running = new AtomicBoolean(false);
    private int order = 0;
    private ApplicationContext context;
    private Environment environment;
    private AtomicInteger port = new AtomicInteger(0);

    protected ApplicationContext getContext() {
        return this.context;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.environment = this.context.getEnvironment();
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected AtomicInteger getPort() {
        return this.port;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        try {
            this.stop();
        }
        catch (Exception e) {
            logger.error((Object)"A problem occurred attempting to stop discovery lifecycle", (Throwable)e);
        }
        callback.run();
    }

    public void start() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.port.get() != 0 && this.getConfiguredPort() == 0) {
            this.setConfiguredPort(this.port.get());
        }
        if (!this.running.get() && this.getConfiguredPort() > 0) {
            this.register();
            if (this.shouldRegisterManagement()) {
                this.registerManagement();
            }
            this.context.publishEvent(new InstanceRegisteredEvent<Object>(this, this.getConfiguration()));
            this.running.compareAndSet(false, true);
        }
    }

    protected abstract int getConfiguredPort();

    protected abstract void setConfiguredPort(int var1);

    protected boolean shouldRegisterManagement() {
        return this.getManagementPort() != null && ManagementServerPortUtils.isDifferent((BeanFactory)this.context);
    }

    protected abstract Object getConfiguration();

    protected abstract void register();

    protected void registerManagement() {
    }

    protected abstract void deregister();

    protected void deregisterManagement() {
    }

    protected abstract boolean isEnabled();

    protected String getManagementServiceId() {
        return String.valueOf(this.context.getId()) + ":management";
    }

    protected String getManagementServiceName() {
        return String.valueOf(this.getAppName()) + ":management";
    }

    protected Integer getManagementPort() {
        return ManagementServerPortUtils.getPort((BeanFactory)this.context);
    }

    protected String getAppName() {
        return this.environment.getProperty("spring.application.name", "application");
    }

    public void stop() {
        if (this.running.compareAndSet(true, false) && this.isEnabled()) {
            this.deregister();
            if (this.shouldRegisterManagement()) {
                this.deregisterManagement();
            }
        }
    }

    @PreDestroy
    public void destroy() {
        this.stop();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getOrder() {
        return this.order;
    }

    public int getPhase() {
        return 0;
    }

    public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
        if (!"management".equals(event.getApplicationContext().getNamespace())) {
            this.port.compareAndSet(0, event.getEmbeddedServletContainer().getPort());
            this.start();
        }
    }
}

