/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.common.security.support.CoreSecurityRoles;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ProviderRoleMapping {
    private String oauthScopePrefix = "dataflow.";
    private String rolePrefix = "ROLE_";
    private String groupClaim = "roles";
    private boolean mapOauthScopes = false;
    private boolean parseOauthScopePathParts = true;
    private boolean mapGroupClaims = false;
    private Map<String, String> roleMappings = new HashMap<String, String>(0);
    private Map<String, String> groupMappings = new HashMap<String, String>(0);
    private String principalClaimName;

    public ProviderRoleMapping() {
    }

    public ProviderRoleMapping(boolean mapOauthScopes) {
        this.mapOauthScopes = mapOauthScopes;
    }

    public ProviderRoleMapping(boolean mapOauthScopes, Map<String, String> roleMappings) {
        Assert.notNull(roleMappings, (String)"roleMappings must not be null.");
        this.mapOauthScopes = mapOauthScopes;
        this.roleMappings = roleMappings;
    }

    public boolean isParseOauthScopePathParts() {
        return this.parseOauthScopePathParts;
    }

    public void setParseOauthScopePathParts(boolean parseOauthScopePathParts) {
        this.parseOauthScopePathParts = parseOauthScopePathParts;
    }

    public boolean isMapOauthScopes() {
        return this.mapOauthScopes;
    }

    public void setMapOauthScopes(boolean mapOauthScopes) {
        this.mapOauthScopes = mapOauthScopes;
    }

    public boolean isMapGroupClaims() {
        return this.mapGroupClaims;
    }

    public void setMapGroupClaims(boolean mapGroupClaims) {
        this.mapGroupClaims = mapGroupClaims;
    }

    public Map<String, String> getRoleMappings() {
        return this.roleMappings;
    }

    public ProviderRoleMapping addRoleMapping(String oauthScope, String roleName) {
        this.roleMappings.put(oauthScope, roleName);
        return this;
    }

    public Map<String, String> getGroupMappings() {
        return this.groupMappings;
    }

    public void setGroupMappings(Map<String, String> groupMappings) {
        this.groupMappings = groupMappings;
    }

    public String getGroupClaim() {
        return this.groupClaim;
    }

    public void setGroupClaim(String groupClaim) {
        this.groupClaim = groupClaim;
    }

    public String getPrincipalClaimName() {
        return this.principalClaimName;
    }

    public void setPrincipalClaimName(String principalClaimName) {
        this.principalClaimName = principalClaimName;
    }

    public Map<CoreSecurityRoles, String> convertGroupMappingKeysToCoreSecurityRoles() {
        HashMap<CoreSecurityRoles, String> groupMappings = new HashMap<CoreSecurityRoles, String>(0);
        if (CollectionUtils.isEmpty(this.groupMappings)) {
            for (CoreSecurityRoles roleEnum : CoreSecurityRoles.values()) {
                String roleName = this.oauthScopePrefix + roleEnum.getKey();
                groupMappings.put(roleEnum, roleName);
            }
            return groupMappings;
        }
        ArrayList<CoreSecurityRoles> unmappedRoles = new ArrayList<CoreSecurityRoles>(0);
        for (CoreSecurityRoles coreRole : CoreSecurityRoles.values()) {
            String coreSecurityRoleName = this.rolePrefix.length() > 0 && !coreRole.getKey().startsWith(this.rolePrefix) ? this.rolePrefix + coreRole.getKey() : coreRole.getKey();
            String oauthScope = this.groupMappings.get(coreSecurityRoleName);
            if (oauthScope == null) {
                unmappedRoles.add(coreRole);
                continue;
            }
            groupMappings.put(coreRole, oauthScope);
        }
        if (!unmappedRoles.isEmpty()) {
            throw new IllegalArgumentException(String.format("The following %s %s not mapped: %s.", unmappedRoles.size(), unmappedRoles.size() > 1 ? "roles are" : "role is", StringUtils.collectionToDelimitedString(unmappedRoles, (String)", ")));
        }
        return groupMappings;
    }

    public Map<CoreSecurityRoles, String> convertRoleMappingKeysToCoreSecurityRoles() {
        HashMap<CoreSecurityRoles, String> roleMappings = new HashMap<CoreSecurityRoles, String>(0);
        if (CollectionUtils.isEmpty(this.roleMappings)) {
            for (CoreSecurityRoles roleEnum : CoreSecurityRoles.values()) {
                String roleName = this.oauthScopePrefix + roleEnum.getKey();
                roleMappings.put(roleEnum, roleName);
            }
            return roleMappings;
        }
        ArrayList<CoreSecurityRoles> unmappedRoles = new ArrayList<CoreSecurityRoles>(0);
        for (CoreSecurityRoles coreRole : CoreSecurityRoles.values()) {
            String coreSecurityRoleName = this.rolePrefix.length() > 0 && !coreRole.getKey().startsWith(this.rolePrefix) ? this.rolePrefix + coreRole.getKey() : coreRole.getKey();
            String oauthScope = this.roleMappings.get(coreSecurityRoleName);
            if (oauthScope == null) {
                unmappedRoles.add(coreRole);
                continue;
            }
            roleMappings.put(coreRole, oauthScope);
        }
        if (!unmappedRoles.isEmpty()) {
            throw new IllegalArgumentException(String.format("The following %s %s not mapped: %s.", unmappedRoles.size(), unmappedRoles.size() > 1 ? "roles are" : "role is", StringUtils.collectionToDelimitedString(unmappedRoles, (String)", ")));
        }
        return roleMappings;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix cannot be null");
        this.rolePrefix = rolePrefix;
    }

    public String getOauthScopePrefix() {
        return this.oauthScopePrefix;
    }

    public void setOauthScopePrefix(String oauthScopePrefix) {
        Assert.notNull((Object)this.rolePrefix, (String)"oauthScopePrefix cannot be null");
        this.oauthScopePrefix = oauthScopePrefix;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }
}

