/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2PasswordGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.OpaqueTokenAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.web.client.ResourceAccessException;

public class ManualOAuthAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(ManualOAuthAuthenticationProvider.class);
    private final OAuth2AccessTokenResponseClient<OAuth2PasswordGrantRequest> oAuth2PasswordTokenResponseClient;
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final AuthenticationProvider authenticationProvider;
    private final String providerId;

    public ManualOAuthAuthenticationProvider(OAuth2AccessTokenResponseClient<OAuth2PasswordGrantRequest> oAuth2PasswordTokenResponseClient, ClientRegistrationRepository clientRegistrationRepository, OpaqueTokenIntrospector opaqueTokenIntrospector, String providerId) {
        this.oAuth2PasswordTokenResponseClient = oAuth2PasswordTokenResponseClient;
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authenticationProvider = new OpaqueTokenAuthenticationProvider(opaqueTokenIntrospector);
        this.providerId = providerId;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2AccessTokenResponse accessTokenResponse;
        String username = authentication.getName();
        String password = authentication.getCredentials().toString();
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(this.providerId);
        ClientRegistration clientRegistrationPassword = ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).authorizationGrantType(AuthorizationGrantType.PASSWORD).build();
        OAuth2PasswordGrantRequest grantRequest = new OAuth2PasswordGrantRequest(clientRegistrationPassword, username, password);
        String accessTokenUri = clientRegistration.getProviderDetails().getTokenUri();
        try {
            accessTokenResponse = this.oAuth2PasswordTokenResponseClient.getTokenResponse((AbstractOAuth2AuthorizationGrantRequest)grantRequest);
            logger.warn("Authenticating user '{}' using accessTokenUri '{}'.", (Object)username, (Object)accessTokenUri);
        }
        catch (OAuth2AuthorizationException e) {
            if (e.getCause() instanceof ResourceAccessException) {
                String errorMessage = String.format("While authenticating user '%s': Unable to access accessTokenUri '%s'.", username, accessTokenUri);
                logger.error(errorMessage + " Error message: {}.", (Object)e.getCause().getMessage());
                throw new AuthenticationServiceException(errorMessage, (Throwable)e);
            }
            throw new BadCredentialsException(String.format("Access denied for user '%s'.", username), (Throwable)e);
        }
        BearerTokenAuthenticationToken authenticationRequest = new BearerTokenAuthenticationToken(accessTokenResponse.getAccessToken().getTokenValue());
        Authentication newAuthentication = null;
        try {
            newAuthentication = this.authenticationProvider.authenticate((Authentication)authenticationRequest);
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication(newAuthentication);
            SecurityContextHolder.setContext((SecurityContext)context);
        }
        catch (AuthenticationException failed) {
            SecurityContextHolder.clearContext();
            logger.warn("Authentication request for failed!", (Throwable)failed);
        }
        return newAuthentication;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

