/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.util.Set;
import org.springframework.cloud.common.security.support.AuthoritiesMapper;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.StringUtils;

public class CustomOAuth2OidcUserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    final OidcUserService delegate = new OidcUserService();
    final AuthoritiesMapper authorityMapper;

    public CustomOAuth2OidcUserService(AuthoritiesMapper authorityMapper) {
        this.authorityMapper = authorityMapper;
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = this.delegate.loadUser(userRequest);
        OAuth2AccessToken accessToken = userRequest.getAccessToken();
        Set<GrantedAuthority> mappedAuthorities = this.authorityMapper.mapScopesToAuthorities(userRequest.getClientRegistration().getRegistrationId(), accessToken.getScopes(), accessToken.getTokenValue());
        String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
        DefaultOidcUser oidcUserToReturn = StringUtils.hasText((String)userNameAttributeName) ? new DefaultOidcUser(mappedAuthorities, userRequest.getIdToken(), oidcUser.getUserInfo(), userNameAttributeName) : new DefaultOidcUser(mappedAuthorities, userRequest.getIdToken(), oidcUser.getUserInfo());
        return oidcUserToReturn;
    }
}

