/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.common.security.support.AuthoritiesMapper;
import org.springframework.cloud.common.security.support.DefaultPrincipalExtractor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.DefaultOAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.NimbusOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;

public class CustomAuthoritiesOpaqueTokenIntrospector
implements OpaqueTokenIntrospector {
    private final OpaqueTokenIntrospector delegate;
    private DefaultPrincipalExtractor principalExtractor;
    private AuthoritiesMapper authorityMapper;

    public CustomAuthoritiesOpaqueTokenIntrospector(String introspectionUri, String clientId, String clientSecret, AuthoritiesMapper authorityMapper) {
        this.delegate = new NimbusOpaqueTokenIntrospector(introspectionUri, clientId, clientSecret);
        this.principalExtractor = new DefaultPrincipalExtractor();
        this.authorityMapper = authorityMapper;
    }

    public OAuth2AuthenticatedPrincipal introspect(String token) {
        OAuth2AuthenticatedPrincipal principal = this.delegate.introspect(token);
        Object principalName = this.principalExtractor.extractPrincipal(principal.getAttributes());
        return new DefaultOAuth2AuthenticatedPrincipal(principalName.toString(), principal.getAttributes(), this.extractAuthorities(principal, token));
    }

    private Collection<GrantedAuthority> extractAuthorities(OAuth2AuthenticatedPrincipal principal, String token) {
        List scopes = (List)principal.getAttribute("scope");
        HashSet<String> scopesAsSet = new HashSet<String>(scopes);
        Set<GrantedAuthority> authorities = this.authorityMapper.mapScopesToAuthorities(null, scopesAsSet, token);
        return authorities;
    }

    public void setPrincipalExtractor(DefaultPrincipalExtractor principalExtractor) {
        this.principalExtractor = principalExtractor;
    }

    public void setAuthorityMapper(AuthoritiesMapper authorityMapper) {
        this.authorityMapper = authorityMapper;
    }
}

