/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.common.security.core.support.OAuth2TokenUtilsService;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.util.Assert;

public class AccessTokenClearingLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenClearingLogoutSuccessHandler.class);
    final OAuth2TokenUtilsService oauth2TokenUtilsService;

    public AccessTokenClearingLogoutSuccessHandler(OAuth2TokenUtilsService oauth2TokenUtilsService) {
        Assert.notNull((Object)oauth2TokenUtilsService, (String)"oauth2TokenUtilsService must not be null.");
        this.oauth2TokenUtilsService = oauth2TokenUtilsService;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken oauth2AuthenticationToken = (OAuth2AuthenticationToken)authentication;
            OAuth2AuthorizedClient oauth2AuthorizedClient = this.oauth2TokenUtilsService.getAuthorizedClient(oauth2AuthenticationToken);
            this.oauth2TokenUtilsService.removeAuthorizedClient(oauth2AuthorizedClient);
            logger.info("Removed OAuth2AuthorizedClient.");
        }
        super.handle(request, response, authentication);
    }
}

