/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import org.springframework.cloud.common.security.core.support.OAuth2TokenUtilsService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultOAuth2TokenUtilsService
implements OAuth2TokenUtilsService {
    private final OAuth2AuthorizedClientService oauth2AuthorizedClientService;

    public DefaultOAuth2TokenUtilsService(OAuth2AuthorizedClientService oauth2AuthorizedClientService) {
        Assert.notNull((Object)oauth2AuthorizedClientService, (String)"oauth2AuthorizedClientService must not be null.");
        this.oauth2AuthorizedClientService = oauth2AuthorizedClientService;
    }

    public String getAccessTokenOfAuthenticatedUser() {
        String accessTokenOfAuthenticatedUser;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new IllegalStateException("Cannot retrieve the authentication object from the SecurityContext. Are you authenticated?");
        }
        if (authentication instanceof BearerTokenAuthentication) {
            accessTokenOfAuthenticatedUser = ((OAuth2AccessToken)((BearerTokenAuthentication)authentication).getToken()).getTokenValue();
        } else if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken oauth2AuthenticationToken = (OAuth2AuthenticationToken)authentication;
            OAuth2AuthorizedClient oauth2AuthorizedClient = this.getAuthorizedClient(oauth2AuthenticationToken);
            accessTokenOfAuthenticatedUser = oauth2AuthorizedClient.getAccessToken().getTokenValue();
        } else if (authentication instanceof JwtAuthenticationToken) {
            AbstractOAuth2Token token = (AbstractOAuth2Token)authentication.getCredentials();
            accessTokenOfAuthenticatedUser = token.getTokenValue();
        } else {
            throw new IllegalStateException("Unsupported authentication object type " + authentication);
        }
        return accessTokenOfAuthenticatedUser;
    }

    public OAuth2AuthorizedClient getAuthorizedClient(OAuth2AuthenticationToken auth2AuthenticationToken) {
        String principalName = auth2AuthenticationToken.getName();
        String clientRegistrationId = auth2AuthenticationToken.getAuthorizedClientRegistrationId();
        if (StringUtils.isEmpty((Object)principalName)) {
            throw new IllegalStateException("The retrieved principalName must not be null or empty.");
        }
        if (StringUtils.isEmpty((Object)clientRegistrationId)) {
            throw new IllegalStateException("The retrieved clientRegistrationId must not be null or empty.");
        }
        OAuth2AuthorizedClient oauth2AuthorizedClient = this.oauth2AuthorizedClientService.loadAuthorizedClient(clientRegistrationId, principalName);
        if (oauth2AuthorizedClient == null) {
            throw new IllegalStateException(String.format("No oauth2AuthorizedClient returned for clientRegistrationId '%s' and principalName '%s'.", clientRegistrationId, principalName));
        }
        return oauth2AuthorizedClient;
    }

    public void removeAuthorizedClient(OAuth2AuthorizedClient auth2AuthorizedClient) {
        Assert.notNull((Object)auth2AuthorizedClient, (String)"The auth2AuthorizedClient must not be null.");
        this.oauth2AuthorizedClientService.removeAuthorizedClient(auth2AuthorizedClient.getClientRegistration().getRegistrationId(), auth2AuthorizedClient.getPrincipalName());
    }
}

