/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.util.Arrays;
import org.springframework.util.Assert;

public enum CoreSecurityRoles {
    VIEW("VIEW", "view role"),
    CREATE("CREATE", "role for create operations"),
    MANAGE("MANAGE", "role for the boot management endpoints");

    private String key;
    private String name;

    private CoreSecurityRoles(String key, String name) {
        this.key = key;
        this.name = name;
    }

    public static CoreSecurityRoles fromKey(String role) {
        Assert.hasText((String)role, (String)"Parameter role must not be null or empty.");
        for (CoreSecurityRoles roleType : CoreSecurityRoles.values()) {
            if (!roleType.getKey().equals(role)) continue;
            return roleType;
        }
        return null;
    }

    public static String[] getAllRolesAsStringArray() {
        return (String[])Arrays.stream(CoreSecurityRoles.values()).map(CoreSecurityRoles::getKey).toArray(String[]::new);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }
}

