/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security;

import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.common.security.support.LdapAuthorityMapper;
import org.springframework.cloud.common.security.support.LdapSecurityProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.configurers.ldap.LdapAuthenticationProviderConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.util.StringUtils;

@Configuration
public class LdapAuthenticationConfiguration
extends GlobalAuthenticationConfigurerAdapter {
    @Autowired
    private LdapSecurityProperties ldapSecurityProperties;

    public void init(AuthenticationManagerBuilder auth) throws Exception {
        LdapAuthenticationProviderConfigurer ldapConfigurer = auth.ldapAuthentication();
        String rolePrefix = "ROLE_";
        ldapConfigurer.rolePrefix("ROLE_");
        if (this.ldapSecurityProperties.getRoleMappings() != null && !this.ldapSecurityProperties.getRoleMappings().isEmpty()) {
            LdapAuthorityMapper ldapAuthorityMapper = new LdapAuthorityMapper(this.ldapSecurityProperties.getRoleMappings());
            ldapAuthorityMapper.setRolePrefix("ROLE_");
            ldapConfigurer.authoritiesMapper((GrantedAuthoritiesMapper)ldapAuthorityMapper);
        }
        ldapConfigurer.contextSource().url(this.ldapSecurityProperties.getUrl().toString()).managerDn(this.ldapSecurityProperties.getManagerDn()).managerPassword(this.ldapSecurityProperties.getManagerPassword());
        if (!StringUtils.isEmpty((Object)this.ldapSecurityProperties.getUserDnPattern())) {
            ldapConfigurer.userDnPatterns(new String[]{this.ldapSecurityProperties.getUserDnPattern()});
        }
        if (!StringUtils.isEmpty((Object)this.ldapSecurityProperties.getUserSearchFilter())) {
            ldapConfigurer.userSearchBase(this.ldapSecurityProperties.getUserSearchBase()).userSearchFilter(this.ldapSecurityProperties.getUserSearchFilter());
        }
        if (!StringUtils.isEmpty((Object)this.ldapSecurityProperties.getGroupSearchFilter())) {
            ldapConfigurer.groupSearchBase(this.ldapSecurityProperties.getGroupSearchBase()).groupSearchFilter(this.ldapSecurityProperties.getGroupSearchFilter()).groupRoleAttribute(this.ldapSecurityProperties.getGroupRoleAttribute());
        } else {
            ldapConfigurer.ldapAuthoritiesPopulator(new LdapAuthoritiesPopulator(){

                public Collection<? extends GrantedAuthority> getGrantedAuthorities(DirContextOperations userData, String username) {
                    return Collections.singleton(new SimpleGrantedAuthority("ROLE_MANAGE"));
                }
            });
        }
    }
}

