/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.cloud.common.security.BasicAuthSecurityConfiguration;
import org.springframework.cloud.common.security.support.CoreSecurityRoles;
import org.springframework.cloud.common.security.support.OnDefaultBootUserAuthenticationEnabled;
import org.springframework.cloud.common.security.support.OnSecurityEnabledAndOAuth2Disabled;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.util.StringUtils;

@Configuration
@Conditional(value={OnDefaultBootUserAuthenticationEnabled.class, OnSecurityEnabledAndOAuth2Disabled.class})
public class DefaultBootUserAuthenticationConfiguration
extends GlobalAuthenticationConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthSecurityConfiguration.class);
    @Autowired
    private SecurityProperties securityProperties;
    @Autowired(required=false)
    private ManagementServerProperties managementServerProperties;

    public void init(AuthenticationManagerBuilder auth) throws Exception {
        SecurityProperties.User user = this.securityProperties.getUser();
        SecurityProperties.User defaultSpringBootUser = new SecurityProperties().getUser();
        if (this.managementServerProperties != null && this.managementServerProperties.getSecurity().getRoles().size() == 1 && "MANAGE".equals(this.managementServerProperties.getSecurity().getRoles().get(0))) {
            defaultSpringBootUser.getRole().add("MANAGE");
        }
        boolean hasDefaultRoles = defaultSpringBootUser.getName().equals(user.getName()) && user.getRole().size() == defaultSpringBootUser.getRole().size() && defaultSpringBootUser.getRole().equals(user.getRole());
        Object[] rolesToPopulate = hasDefaultRoles ? CoreSecurityRoles.getAllRolesAsStringArray() : user.getRole().toArray(new String[user.getRole().size()]);
        if (user.isDefaultPassword()) {
            logger.info(String.format("%n%nUsing default security password: %s with roles '%s'%n", user.getPassword(), StringUtils.arrayToCommaDelimitedString((Object[])rolesToPopulate)));
        }
        auth.inMemoryAuthentication().withUser(user.getName()).password(user.getPassword()).roles((String[])rolesToPopulate);
    }
}

