/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery.reactive;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleDnsBasedReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(SimpleDnsBasedReactiveDiscoveryClient.class);
    private final ServiceIdToHostnameConverter serviceIdToHostnameConverter;

    public SimpleDnsBasedReactiveDiscoveryClient(ServiceIdToHostnameConverter serviceIdToHostnameConverter) {
        this.serviceIdToHostnameConverter = serviceIdToHostnameConverter;
    }

    public SimpleDnsBasedReactiveDiscoveryClient(CloudFoundryDiscoveryProperties properties) {
        this((String serviceId) -> serviceId + "." + properties.getInternalDomain());
    }

    public String description() {
        return "DNS Based CF Service Reactive Discovery Client";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Mono.justOrEmpty((Object)this.serviceIdToHostnameConverter.toHostname(serviceId)).flatMapMany(this.getInetAddresses()).map(address -> new DefaultServiceInstance(serviceId, address.getHostAddress(), 8080, false));
    }

    private Function<String, Publisher<? extends InetAddress>> getInetAddresses() {
        return hostname -> {
            try {
                return Flux.fromArray((Object[])InetAddress.getAllByName(hostname));
            }
            catch (UnknownHostException e) {
                log.warn("{}", (Object)e.getMessage());
                return Flux.empty();
            }
        };
    }

    public Flux<String> getServices() {
        log.warn("getServices is not supported");
        return Flux.empty();
    }

    @FunctionalInterface
    public static interface ServiceIdToHostnameConverter {
        public String toHostname(String var1);
    }
}

