/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.loadbalancer.ServerList;
import javax.annotation.PostConstruct;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryServerList;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CloudFoundryRibbonClientConfiguration {
    protected static final String DEFAULT_NAMESPACE = "ribbon";
    protected static final String VALUE_NOT_SET = "__not__set__";
    @Value(value="${ribbon.client.name}")
    private String serviceId;

    public CloudFoundryRibbonClientConfiguration() {
    }

    public CloudFoundryRibbonClientConfiguration(String svcId) {
        this.serviceId = svcId;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerList<?> ribbonServerList(CloudFoundryClient cloudFoundryClient, IClientConfig config) {
        CloudFoundryServerList cloudFoundryServerList = new CloudFoundryServerList(cloudFoundryClient);
        cloudFoundryServerList.initWithNiwsConfig(config);
        return cloudFoundryServerList;
    }

    @PostConstruct
    public void postConstruct() {
        this.setProp(this.serviceId, CommonClientConfigKey.DeploymentContextBasedVipAddresses.key(), this.serviceId);
        this.setProp(this.serviceId, CommonClientConfigKey.EnableZoneAffinity.key(), "true");
    }

    protected void setProp(String serviceId, String suffix, String value) {
        String key = this.getKey(serviceId, suffix);
        DynamicStringProperty property = this.getProperty(key);
        if (property.get().equals(VALUE_NOT_SET)) {
            ConfigurationManager.getConfigInstance().setProperty(key, (Object)value);
        }
    }

    protected DynamicStringProperty getProperty(String key) {
        return DynamicPropertyFactory.getInstance().getStringProperty(key, VALUE_NOT_SET);
    }

    protected String getKey(String serviceId, String suffix) {
        return serviceId + "." + DEFAULT_NAMESPACE + "." + suffix;
    }
}

