/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.cloud.cloudfoundry.discovery")
public class CloudFoundryDiscoveryProperties {
    private String url = "https://api.run.pivotal.io";
    private String username;
    private String password;
    private String org;
    @Value(value="${vcap.application.space_name:}")
    private String space;
    private boolean enabled = true;
    private long heartbeatFrequency = 5000L;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String cloudControllerUrl) {
        this.url = cloudControllerUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String email) {
        this.username = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public long getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public void setHeartbeatFrequency(long heartbeatFrequency) {
        this.heartbeatFrequency = heartbeatFrequency;
    }
}

