/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonGenerationException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonGenerator;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.SerializerProvider;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.ser.std.DateTimeSerializerBase;

@JacksonStdImpl
public class CalendarSerializer
extends DateTimeSerializerBase<Calendar> {
    public static final CalendarSerializer instance = new CalendarSerializer();

    public CalendarSerializer() {
        this(false, null);
    }

    public CalendarSerializer(boolean bl, DateFormat dateFormat) {
        super(Calendar.class, bl, dateFormat);
    }

    public CalendarSerializer withFormat(boolean bl, DateFormat dateFormat) {
        if (bl) {
            return new CalendarSerializer(true, null);
        }
        return new CalendarSerializer(false, dateFormat);
    }

    @Override
    protected long _timestamp(Calendar calendar) {
        return calendar == null ? 0L : calendar.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Calendar calendar, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (this._useTimestamp) {
            jsonGenerator.writeNumber(this._timestamp(calendar));
        } else if (this._customFormat != null) {
            DateFormat dateFormat = this._customFormat;
            synchronized (dateFormat) {
                jsonGenerator.writeString(this._customFormat.format(calendar.getTime()));
            }
        } else {
            serializerProvider.defaultSerializeDateValue(calendar.getTime(), jsonGenerator);
        }
    }
}

