/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.springretry;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.circuitbreaker.springretry.SpringRetryCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.support.RetryTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RetryTemplate.class})
public class SpringRetryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakerFactory.class})
    public CircuitBreakerFactory<?, ?> springRetryCircuitBreakerFactory(@Nullable List<Customizer<SpringRetryCircuitBreakerFactory>> customizers) {
        SpringRetryCircuitBreakerFactory factory = new SpringRetryCircuitBreakerFactory();
        if (customizers != null) {
            customizers.forEach(customizer -> customizer.customize((Object)factory));
        }
        return factory;
    }
}

