/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.springretry;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.circuitbreaker.springretry.SpringRetryCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.support.RetryTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RetryTemplate.class})
public class SpringRetryAutoConfiguration {
    @Autowired(required=false)
    private List<Customizer<SpringRetryCircuitBreakerFactory>> customizers = new ArrayList<Customizer<SpringRetryCircuitBreakerFactory>>();

    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakerFactory.class})
    public CircuitBreakerFactory springRetryCircuitBreakerFactory() {
        SpringRetryCircuitBreakerFactory factory = new SpringRetryCircuitBreakerFactory();
        this.customizers.forEach(customizer -> customizer.customize((Object)factory));
        return factory;
    }
}

