/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.timelimiter.TimeLimiter;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigurationProperties;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4jBulkheadConfigurationBuilder;
import org.springframework.cloud.client.circuitbreaker.Customizer;

public class Resilience4jBulkheadProvider {
    private final ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry;
    private final BulkheadRegistry bulkheadRegistry;
    private final ConcurrentHashMap<String, Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration> configurations = new ConcurrentHashMap();
    private Function<String, Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration> defaultConfiguration;
    private boolean semaphoreDefaultBulkhead = false;

    public Resilience4jBulkheadProvider(ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry, BulkheadRegistry bulkheadRegistry, Resilience4JConfigurationProperties resilience4JConfigurationProperties) {
        this.bulkheadRegistry = bulkheadRegistry;
        this.threadPoolBulkheadRegistry = threadPoolBulkheadRegistry;
        this.defaultConfiguration = id -> new Resilience4jBulkheadConfigurationBuilder().bulkheadConfig((BulkheadConfig)this.bulkheadRegistry.getDefaultConfig()).threadPoolBulkheadConfig((ThreadPoolBulkheadConfig)this.threadPoolBulkheadRegistry.getDefaultConfig()).build();
        this.semaphoreDefaultBulkhead = resilience4JConfigurationProperties.isEnableSemaphoreDefaultBulkhead();
    }

    public void configureDefault(Function<String, Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void configure(Consumer<Resilience4jBulkheadConfigurationBuilder> consumer, String ... ids) {
        for (String id : ids) {
            Resilience4jBulkheadConfigurationBuilder builder = new Resilience4jBulkheadConfigurationBuilder();
            consumer.accept(builder);
            Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = builder.build();
            this.configurations.put(id, configuration);
        }
    }

    public void addBulkheadCustomizer(Customizer<Bulkhead> customizer, String ... ids) {
        for (String id : ids) {
            Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = this.configurations.computeIfAbsent(id, this.defaultConfiguration);
            Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(id, configuration.getBulkheadConfig());
            customizer.customize((Object)bulkhead);
        }
    }

    public void addThreadPoolBulkheadCustomizer(Customizer<ThreadPoolBulkhead> customizer, String ... ids) {
        for (String id : ids) {
            Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = this.configurations.computeIfAbsent(id, this.defaultConfiguration);
            ThreadPoolBulkhead threadPoolBulkhead = this.threadPoolBulkheadRegistry.bulkhead(id, configuration.getThreadPoolBulkheadConfig());
            customizer.customize((Object)threadPoolBulkhead);
        }
    }

    protected BulkheadRegistry getBulkheadRegistry() {
        return this.bulkheadRegistry;
    }

    protected ThreadPoolBulkheadRegistry getThreadPoolBulkheadRegistry() {
        return this.threadPoolBulkheadRegistry;
    }

    public <T> T run(String id, Supplier<T> toRun, Function<Throwable, T> fallback, CircuitBreaker circuitBreaker, TimeLimiter timeLimiter, Map<String, String> tags) {
        Supplier<CompletionStage<T>> bulkheadCall = this.decorateBulkhead(id, tags, toRun);
        Callable<T> timeLimiterCall = this.decorateTimeLimiter(bulkheadCall, timeLimiter);
        Callable circuitBreakerCall = circuitBreaker.decorateCallable(timeLimiterCall);
        try {
            return (T)circuitBreakerCall.call();
        }
        catch (Throwable t) {
            return fallback.apply(t);
        }
    }

    private <T> Supplier<CompletionStage<T>> decorateBulkhead(String id, Map<String, String> tags, Supplier<T> supplier) {
        Resilience4jBulkheadConfigurationBuilder.BulkheadConfiguration configuration = this.configurations.computeIfAbsent(id, this.defaultConfiguration);
        if (this.semaphoreDefaultBulkhead || this.bulkheadRegistry.find(id).isPresent() && !this.threadPoolBulkheadRegistry.find(id).isPresent()) {
            Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(id, configuration.getBulkheadConfig(), tags);
            CompletableFuture asyncCall = CompletableFuture.supplyAsync(supplier);
            return Bulkhead.decorateCompletionStage((Bulkhead)bulkhead, () -> asyncCall);
        }
        ThreadPoolBulkhead threadPoolBulkhead = this.threadPoolBulkheadRegistry.bulkhead(id, configuration.getThreadPoolBulkheadConfig(), tags);
        return threadPoolBulkhead.decorateSupplier(supplier);
    }

    private <T> Callable<T> decorateTimeLimiter(Supplier<CompletionStage<T>> supplier, TimeLimiter timeLimiter) {
        Supplier<Future> futureSupplier = () -> ((CompletionStage)supplier.get()).toCompletableFuture();
        return timeLimiter.decorateFutureSupplier(futureSupplier);
    }
}

