/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.retry;

import java.util.function.Function;
import org.springframework.cloud.circuitbreaker.retry.FrameworkRetryCircuitBreaker;
import org.springframework.cloud.circuitbreaker.retry.FrameworkRetryConfig;
import org.springframework.cloud.circuitbreaker.retry.FrameworkRetryConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.util.Assert;

public class FrameworkRetryCircuitBreakerFactory
extends CircuitBreakerFactory<FrameworkRetryConfig, FrameworkRetryConfigBuilder> {
    private Function<String, FrameworkRetryConfig> defaultConfig = id -> new FrameworkRetryConfigBuilder((String)id).build();

    protected FrameworkRetryConfigBuilder configBuilder(String id) {
        return new FrameworkRetryConfigBuilder(id);
    }

    public void configureDefault(Function<String, FrameworkRetryConfig> defaultConfiguration) {
        this.defaultConfig = defaultConfiguration;
    }

    public CircuitBreaker create(String id) {
        Assert.hasText((String)id, (String)"A circuit breaker must have an id");
        FrameworkRetryConfig config = this.getConfigurations().computeIfAbsent(id, this.defaultConfig);
        return new FrameworkRetryCircuitBreaker(id, config);
    }
}

