/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.retry;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.circuitbreaker.retry.CircuitBreakerRetryPolicy;
import org.springframework.cloud.circuitbreaker.retry.FrameworkRetryConfig;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.util.Assert;

public class FrameworkRetryCircuitBreaker
implements CircuitBreaker {
    private final String id;
    private final FrameworkRetryConfig config;
    private final @Nullable CircuitBreakerRetryPolicy circuitBreakerPolicy;

    public FrameworkRetryCircuitBreaker(String id, FrameworkRetryConfig config) {
        this.id = id;
        this.config = config;
        this.circuitBreakerPolicy = config.getCircuitBreakerRetryPolicy();
    }

    public <T> T run(Supplier<T> toRun, Function<@Nullable Throwable, T> fallback) {
        Assert.notNull((Object)this.circuitBreakerPolicy, (String)"Circuit breaker policy is required");
        if (!this.circuitBreakerPolicy.canRetry()) {
            Throwable lastException = this.circuitBreakerPolicy.getLastException();
            if (lastException == null) {
                lastException = new IllegalStateException("Circuit breaker is open for: " + this.id);
            }
            return fallback.apply(lastException);
        }
        RetryTemplate retryTemplate = new RetryTemplate(this.circuitBreakerPolicy.getRetryPolicy());
        try {
            Object result = retryTemplate.execute(toRun::get);
            this.circuitBreakerPolicy.recordSuccess();
            return (T)result;
        }
        catch (Throwable t) {
            this.circuitBreakerPolicy.recordFailure(t);
            return fallback.apply(t);
        }
    }

    public String getId() {
        return this.id;
    }

    public FrameworkRetryConfig getConfig() {
        return this.config;
    }

    public @Nullable CircuitBreakerRetryPolicy getCircuitBreakerPolicy() {
        return this.circuitBreakerPolicy;
    }
}

