/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.autoconfigure.LifecycleMvcEndpointAutoConfiguration;
import org.springframework.cloud.bus.BusAutoConfiguration;
import org.springframework.cloud.bus.BusBridge;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.PathServiceMatcherAutoConfiguration;
import org.springframework.cloud.bus.StreamBusBridge;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBusEnabled
@ConditionalOnClass(value={StreamBridge.class, BindingServiceConfiguration.class})
@EnableConfigurationProperties(value={BusProperties.class})
@AutoConfigureBefore(value={BindingServiceConfiguration.class, BusAutoConfiguration.class})
@AutoConfigureAfter(value={LifecycleMvcEndpointAutoConfiguration.class, PathServiceMatcherAutoConfiguration.class})
public class BusStreamAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BusBridge.class})
    public StreamBusBridge streamBusBridge(StreamBridge streamBridge, BusProperties properties) {
        return new StreamBusBridge(streamBridge, properties);
    }
}

