/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.core.env.Environment;

public final class MongoDbBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "mongodb";

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            map.from("authentication-database").to("spring.data.mongodb.authentication-database");
            map.from("database").to("spring.data.mongodb.database");
            map.from("grid-fs-database").to("spring.data.mongodb.gridfs.database");
            map.from("host").to("spring.data.mongodb.host");
            map.from("password").to("spring.data.mongodb.password");
            map.from("port").to("spring.data.mongodb.port");
            map.from("uri").to("spring.data.mongodb.uri");
            map.from("username").to("spring.data.mongodb.username");
        });
    }
}

