/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;

public final class Binding {
    public static final String KIND = "kind";
    public static final String PROVIDER = "provider";
    public static final String TYPE = "type";
    private final String name;
    private final Path path;
    private final String provider;
    private final Map<String, String> secret;
    private final String type;

    public Binding(Path path) {
        this(path.getFileName().toString(), path, Binding.createSecretMap(path));
    }

    public Binding(String name, Path path, Map<String, String> secret) {
        this.name = name;
        this.path = path;
        this.secret = new HashMap<String, String>();
        String type = null;
        String provider = null;
        block9: for (Map.Entry<String, String> entry : secret.entrySet()) {
            switch (entry.getKey()) {
                case "type": 
                case "kind": {
                    type = entry.getValue();
                    continue block9;
                }
                case "provider": {
                    provider = entry.getValue();
                    continue block9;
                }
            }
            this.secret.put(entry.getKey(), entry.getValue());
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("%s has no type and is not a valid binding", path));
        }
        this.type = type;
        this.provider = provider;
    }

    private static Map<String, String> createSecretMap(Path path) {
        Map<String, String> secret = Binding.createFilePerEntryMap(path);
        Arrays.asList("metadata", "secret").forEach(d -> secret.putAll(Binding.createFilePerEntryMap(path.resolve((String)d))));
        return secret;
    }

    private static Map<String, String> createFilePerEntryMap(Path path) {
        Map<String, String> map;
        block9: {
            if (!Files.exists(path, new LinkOption[0])) {
                return Collections.emptyMap();
            }
            Stream<Path> paths = Files.list(path);
            try {
                map = paths.filter(p -> {
                    try {
                        return !Files.isHidden(p);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("unable to determine if file '%s' is hidden", p), e);
                    }
                }).filter(p -> !Files.isDirectory(p, new LinkOption[0])).collect(Collectors.toMap(p -> p.getFileName().toString(), p -> {
                    try {
                        return Files.readString(p).trim();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("unable to read file '%s'", p), e);
                    }
                }));
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(String.format("unable to list children of '%s'", path), e);
                }
            }
            paths.close();
        }
        return map;
    }

    public String getName() {
        return this.name;
    }

    public Path getPath() {
        return this.path;
    }

    public Map<String, String> getSecret() {
        return Collections.unmodifiableMap(this.secret);
    }

    public String getType() {
        return this.type;
    }

    @Nullable
    public String getProvider() {
        return this.provider;
    }

    public Path getSecretFilePath(String name) {
        for (String d : Arrays.asList("metadata", "secret")) {
            Path file = this.path.resolve(d).resolve(name);
            if (!Files.exists(file, new LinkOption[0])) continue;
            return file;
        }
        return this.path.resolve(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binding binding = (Binding)o;
        return this.name.equals(binding.name) && this.path.equals(binding.path) && Objects.equals(this.provider, binding.provider) && this.secret.equals(binding.secret) && Objects.equals(this.type, binding.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.path, this.provider, this.secret, this.type);
    }

    public String toString() {
        return "Binding{name='" + this.name + "', path=" + this.path + ", provider='" + this.provider + "', secret=" + new TreeSet<String>(this.secret.keySet()) + ", type='" + this.type + "'}";
    }
}

