/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.core.env.Environment;

final class CouchbaseBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "couchbase";

    CouchbaseBindingsPropertiesProcessor() {
    }

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            map.from("bucket-name").to("spring.data.couchbase.bucket-name");
            map.from("connection-string").to("spring.couchbase.connection-string");
            map.from("password").to("spring.couchbase.password");
            map.from("username").to("spring.couchbase.username");
        });
    }
}

